"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.THRESHOLD_MINUTES = exports.METERING_CONFIGS = exports.KSPM = exports.CSPM = exports.CNVM = exports.CLOUD_SECURITY_TASK_TYPE = exports.CLOUD_DEFEND = exports.ASSETS_SAMPLE_GRANULARITY = exports.AGGREGATION_PRECISION_THRESHOLD = void 0;
var _constants = require("@kbn/cloud-security-posture-plugin/common/constants");
var _constants2 = require("@kbn/cloud-defend-plugin/common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CLOUD_DEFEND_HEARTBEAT_INDEX = 'metrics-cloud_defend.heartbeat';
const CLOUD_SECURITY_TASK_TYPE = exports.CLOUD_SECURITY_TASK_TYPE = 'cloud_security';
const AGGREGATION_PRECISION_THRESHOLD = exports.AGGREGATION_PRECISION_THRESHOLD = 40000;
const ASSETS_SAMPLE_GRANULARITY = exports.ASSETS_SAMPLE_GRANULARITY = '24h';
const THRESHOLD_MINUTES = exports.THRESHOLD_MINUTES = 30;
const CSPM = exports.CSPM = _constants.CSPM_POLICY_TEMPLATE;
const KSPM = exports.KSPM = _constants.KSPM_POLICY_TEMPLATE;
const CNVM = exports.CNVM = _constants.CNVM_POLICY_TEMPLATE;
const CLOUD_DEFEND = exports.CLOUD_DEFEND = _constants2.INTEGRATION_PACKAGE_NAME;
const METERING_CONFIGS = exports.METERING_CONFIGS = {
  [CSPM]: {
    index: _constants.LATEST_FINDINGS_INDEX_PATTERN,
    assets_identifier: 'resource.id'
  },
  [KSPM]: {
    index: _constants.LATEST_FINDINGS_INDEX_PATTERN,
    assets_identifier: 'agent.id'
  },
  [CNVM]: {
    index: _constants.LATEST_VULNERABILITIES_INDEX_PATTERN,
    assets_identifier: 'cloud.instance.id'
  },
  [CLOUD_DEFEND]: {
    index: CLOUD_DEFEND_HEARTBEAT_INDEX,
    assets_identifier: 'agent.id'
  }
};