"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cloudSecurityMetringTaskProperties = void 0;
var _cloud_security_metering = require("./cloud_security_metering");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TASK_INTERVAL = 1800; // 30 minutes

const cloudSecurityMetringTaskProperties = exports.cloudSecurityMetringTaskProperties = {
  taskType: 'cloud-security-usage-reporting-task',
  taskTitle: 'Cloud Security Metring Periodic Tasks',
  meteringCallback: _cloud_security_metering.cloudSecurityMetringCallback,
  interval: `${TASK_INTERVAL.toString()}s`,
  periodSeconds: TASK_INTERVAL,
  version: '1'
};