"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecuritySolutionServerlessPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _dashboards_landing_callout = require("./components/dashboards_landing_callout");
var _upselling = require("./upselling");
var _create_services = require("./common/services/create_services");
var _navigation = require("./navigation");
var _experimental_features = require("../common/experimental_features");
var _util = require("./navigation/util");
var _onboarding = require("./onboarding");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SecuritySolutionServerlessPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "experimentalFeatures", void 0);
    this.initializerContext = initializerContext;
    this.config = this.initializerContext.config.get();
    this.experimentalFeatures = {};
  }
  setup(core, setupDeps) {
    const {
      securitySolution
    } = setupDeps;
    this.experimentalFeatures = (0, _experimental_features.parseExperimentalConfigValue)(this.config.enableExperimental, securitySolution.experimentalFeatures).features;
    setupDeps.discover.showInlineTopNav();
    return {};
  }
  start(core, startDeps) {
    const {
      securitySolution
    } = startDeps;
    const {
      productTypes
    } = this.config;
    const services = (0, _create_services.createServices)(core, startDeps, this.experimentalFeatures);
    (0, _upselling.registerUpsellings)(securitySolution.getUpselling(), productTypes, services);
    securitySolution.setComponents({
      DashboardsLandingCallout: (0, _dashboards_landing_callout.getDashboardsLandingCallout)(services)
    });
    securitySolution.setOnboardingPageSettings.setProductTypes(productTypes);
    securitySolution.setOnboardingPageSettings.setProjectFeaturesUrl((0, _util.getProjectFeaturesUrl)(services.cloud));
    securitySolution.setOnboardingPageSettings.setProjectsUrl((0, _util.getCloudUrl)('projects', services.cloud));
    (0, _onboarding.setOnboardingSettings)(services);
    (0, _navigation.startNavigation)(services);
    return {};
  }
  stop() {}
}
exports.SecuritySolutionServerlessPlugin = SecuritySolutionServerlessPlugin;