"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.enableManagementCardsLanding = void 0;
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SecurityManagementCards = new Map([[_securitySolutionNavigation.ExternalPageName.visualize, 'content'], [_securitySolutionNavigation.ExternalPageName.maps, 'content'], [_securitySolutionNavigation.SecurityPageName.entityAnalyticsManagement, 'alerts']]);
const enableManagementCardsLanding = services => {
  const {
    securitySolution,
    management,
    application
  } = services;
  securitySolution.getNavLinks$().subscribe(navLinks => {
    const cardNavDefinitions = navLinks.reduce((acc, navLink) => {
      if (SecurityManagementCards.has(navLink.id)) {
        var _SecurityManagementCa, _navLink$description, _navLink$landingIcon;
        const {
          appId,
          deepLinkId,
          path
        } = (0, _securitySolutionNavigation.getNavigationPropsFromId)(navLink.id);
        acc[navLink.id] = {
          category: (_SecurityManagementCa = SecurityManagementCards.get(navLink.id)) !== null && _SecurityManagementCa !== void 0 ? _SecurityManagementCa : 'other',
          title: navLink.title,
          description: (_navLink$description = navLink.description) !== null && _navLink$description !== void 0 ? _navLink$description : '',
          icon: (_navLink$landingIcon = navLink.landingIcon) !== null && _navLink$landingIcon !== void 0 ? _navLink$landingIcon : '',
          href: application.getUrlForApp(appId, {
            deepLinkId,
            path
          }),
          skipValidation: true
        };
      }
      return acc;
    }, {});
    management.setupCardsNavigation({
      enabled: true,
      extendCardNavDefinitions: services.serverless.getNavigationCards(services.security.authz.isRoleManagementEnabled(), cardNavDefinitions)
    });
  });
};
exports.enableManagementCardsLanding = enableManagementCardsLanding;