"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Plugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _securitysolutionRules = require("@kbn/securitysolution-rules");
var _server = require("@kbn/core/server");
var _server2 = require("@kbn/alerting-plugin/server");
var _common = require("@kbn/alerting-plugin/common");
var _server3 = require("@kbn/rule-registry-plugin/server");
var _common2 = require("@kbn/fleet-plugin/common");
var _i18n = require("@kbn/i18n");
var _response_actions = require("./endpoint/lib/response_actions");
var _agent = require("./endpoint/routes/agent");
var _endpoint_package_policies_stats = require("./search_strategy/endpoint_package_policies_stats");
var _turn_off_policy_protections = require("./endpoint/migrations/turn_off_policy_protections");
var _endpoint = require("./search_strategy/endpoint");
var _schedule_notification_response_actions = require("./lib/detection_engine/rule_response_actions/schedule_notification_response_actions");
var _siem_guide_config = require("../common/guided_onboarding/siem_guide_config");
var _rule_types = require("./lib/detection_engine/rule_types");
var _routes = require("./routes");
var _limited_concurrency = require("./routes/limited_concurrency");
var _artifacts = require("./endpoint/lib/artifacts");
var _metadata = require("./endpoint/lib/metadata");
var _saved_objects = require("./saved_objects");
var _client = require("./client");
var _config = require("./config");
var _ui_settings = require("./ui_settings");
var _constants = require("../common/constants");
var _metadata2 = require("./endpoint/routes/metadata");
var _policy = require("./endpoint/routes/policy");
var _actions = require("./endpoint/routes/actions");
var _suggestions = require("./endpoint/routes/suggestions");
var _services = require("./endpoint/services");
var _endpoint_app_context_services = require("./endpoint/endpoint_app_context_services");
var _usage = require("./usage");
var _security_solution = require("./search_strategy/security_solution");
var _sender = require("./lib/telemetry/sender");
var _async_sender = require("./lib/telemetry/async_sender");
var _receiver = require("./lib/telemetry/receiver");
var _license = require("./lib/license");
var _license_watch = require("./endpoint/lib/policy/license_watch");
var _preview_policy = _interopRequireDefault(require("./lib/detection_engine/routes/index/preview_policy.json"));
var _rule_monitoring = require("./lib/detection_engine/rule_monitoring");
var _metadata3 = require("./endpoint/services/metadata");
var _rule_actions_legacy = require("./lib/detection_engine/rule_actions_legacy");
var _create_security_rule_type_wrapper = require("./lib/detection_engine/rule_types/create_security_rule_type_wrapper");
var _request_context_factory = require("./request_context_factory");
var _fleet = require("./endpoint/services/fleet");
var _feature_usage = require("./endpoint/services/feature_usage");
var _helpers = require("./lib/telemetry/helpers");
var _artifact = require("./lib/telemetry/artifact");
var _events = require("./lib/telemetry/event_based/events");
var _endpoint_fields = require("./search_strategy/endpoint_fields");
var _constants2 = require("../common/endpoint/constants");
var _product_features_service = require("./lib/product_features_service/product_features_service");
var _risk_scoring_task = require("./lib/entity_analytics/risk_score/tasks/risk_scoring_task");
var _protection_updates_note = require("./endpoint/routes/protection_updates_note");
var _risk_engine = require("../common/entity_analytics/risk_engine");
var _package_v = require("../common/endpoint/utils/package_v2");
var _tools = require("./assistant/tools");
var _turn_off_agent_policy_features = require("./endpoint/migrations/turn_off_agent_policy_features");
var _security_integrations = require("./security_integrations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line no-restricted-imports

class Plugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "pluginContext", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "appClientFactory", void 0);
    (0, _defineProperty2.default)(this, "productFeaturesService", void 0);
    (0, _defineProperty2.default)(this, "ruleMonitoringService", void 0);
    (0, _defineProperty2.default)(this, "endpointAppContextService", new _endpoint_app_context_services.EndpointAppContextService());
    (0, _defineProperty2.default)(this, "telemetryReceiver", void 0);
    (0, _defineProperty2.default)(this, "telemetryEventsSender", void 0);
    (0, _defineProperty2.default)(this, "asyncTelemetryEventsSender", void 0);
    (0, _defineProperty2.default)(this, "lists", void 0);
    // TODO: can we create ListPluginStart?
    (0, _defineProperty2.default)(this, "licensing$", void 0);
    (0, _defineProperty2.default)(this, "policyWatcher", void 0);
    (0, _defineProperty2.default)(this, "manifestTask", void 0);
    (0, _defineProperty2.default)(this, "completeExternalResponseActionsTask", void 0);
    (0, _defineProperty2.default)(this, "checkMetadataTransformsTask", void 0);
    (0, _defineProperty2.default)(this, "telemetryUsageCounter", void 0);
    (0, _defineProperty2.default)(this, "endpointContext", void 0);
    const serverConfig = (0, _config.createConfig)(context);
    this.pluginContext = context;
    this.config = serverConfig;
    this.logger = context.logger.get();
    this.appClientFactory = new _client.AppClientFactory();
    this.productFeaturesService = new _product_features_service.ProductFeaturesService(this.logger, this.config.experimentalFeatures);
    this.ruleMonitoringService = (0, _rule_monitoring.createRuleMonitoringService)(this.config, this.logger);
    this.telemetryEventsSender = new _sender.TelemetryEventsSender(this.logger);
    this.asyncTelemetryEventsSender = new _async_sender.AsyncTelemetryEventsSender(this.logger);
    this.telemetryReceiver = new _receiver.TelemetryReceiver(this.logger);
    this.logger.debug('plugin initialized');
    this.endpointContext = {
      logFactory: this.pluginContext.logger,
      service: this.endpointAppContextService,
      config: () => Promise.resolve(this.config),
      get serverConfig() {
        return serverConfig;
      },
      experimentalFeatures: this.config.experimentalFeatures
    };
    this.completeExternalResponseActionsTask = new _response_actions.CompleteExternalResponseActionsTask({
      endpointAppContext: this.endpointContext
    });
  }
  setup(core, plugins) {
    var _plugins$usageCollect, _plugins$encryptedSav, _plugins$encryptedSav2, _plugins$cloud$isClou;
    this.logger.debug('plugin setup');
    const {
      appClientFactory,
      productFeaturesService,
      pluginContext,
      config,
      logger
    } = this;
    const experimentalFeatures = config.experimentalFeatures;
    (0, _saved_objects.initSavedObjects)(core.savedObjects);
    (0, _ui_settings.initUiSettings)(core.uiSettings, experimentalFeatures, config.enableUiSettingsValidations);
    productFeaturesService.init(plugins.features);
    _events.events.forEach(eventConfig => core.analytics.registerEventType(eventConfig));
    this.ruleMonitoringService.setup(core, plugins);
    if (experimentalFeatures.riskScoringPersistence) {
      (0, _risk_scoring_task.registerRiskScoringTask)({
        getStartServices: core.getStartServices,
        kibanaVersion: pluginContext.env.packageInfo.version,
        logger: this.logger,
        taskManager: plugins.taskManager,
        telemetry: core.analytics,
        entityAnalyticsConfig: config.entityAnalytics
      });
    }
    const requestContextFactory = new _request_context_factory.RequestContextFactory({
      config,
      logger,
      core,
      plugins,
      endpointAppContextService: this.endpointAppContextService,
      ruleMonitoringService: this.ruleMonitoringService,
      kibanaVersion: pluginContext.env.packageInfo.version,
      kibanaBranch: pluginContext.env.packageInfo.branch
    });
    productFeaturesService.registerApiAccessControl(core.http);
    const router = core.http.createRouter();
    core.http.registerRouteHandlerContext(_constants.APP_ID, (context, request) => requestContextFactory.create(context, request));
    this.endpointAppContextService.setup({
      securitySolutionRequestContextFactory: requestContextFactory,
      cloud: plugins.cloud,
      loggerFactory: this.pluginContext.logger
    });
    (0, _usage.initUsageCollectors)({
      core,
      eventLogIndex: plugins.eventLog.getIndexPattern(),
      signalsIndex: _constants.DEFAULT_ALERTS_INDEX,
      ml: plugins.ml,
      usageCollection: plugins.usageCollection,
      logger,
      riskEngineIndexPatterns: {
        all: _risk_engine.allRiskScoreIndexPattern,
        latest: _risk_engine.latestRiskScoreIndexPattern
      }
    });
    this.telemetryUsageCounter = (_plugins$usageCollect = plugins.usageCollection) === null || _plugins$usageCollect === void 0 ? void 0 : _plugins$usageCollect.createUsageCounter(_constants.APP_ID);
    plugins.cases.attachmentFramework.registerExternalReference({
      id: _constants.CASE_ATTACHMENT_ENDPOINT_TYPE_ID
    });
    const {
      ruleDataService
    } = plugins.ruleRegistry;
    let ruleDataClient = null;
    let previewRuleDataClient = null;

    // rule options are used both to create and preview rules.
    const ruleOptions = {
      experimentalFeatures,
      logger: this.logger,
      ml: plugins.ml,
      eventsTelemetry: this.telemetryEventsSender,
      version: pluginContext.env.packageInfo.version,
      licensing: plugins.licensing
    };
    const ruleDataServiceOptions = {
      feature: _constants.SERVER_APP_ID,
      registrationContext: 'security',
      dataset: _server3.Dataset.alerts,
      componentTemplateRefs: [_server2.ECS_COMPONENT_TEMPLATE_NAME],
      componentTemplates: [{
        name: 'mappings',
        mappings: (0, _common.mappingFromFieldMap)(_create_security_rule_type_wrapper.securityRuleTypeFieldMap, false)
      }],
      secondaryAlias: config.signalsIndex
    };
    ruleDataClient = ruleDataService.initializeIndex(ruleDataServiceOptions);
    const previewIlmPolicy = _preview_policy.default.policy;
    previewRuleDataClient = ruleDataService.initializeIndex({
      ...ruleDataServiceOptions,
      additionalPrefix: '.preview',
      ilmPolicy: previewIlmPolicy,
      secondaryAlias: undefined
    });
    const securityRuleTypeOptions = {
      lists: plugins.lists,
      logger: this.logger,
      config: this.config,
      publicBaseUrl: core.http.basePath.publicBaseUrl,
      ruleDataClient,
      ruleExecutionLoggerFactory: this.ruleMonitoringService.createRuleExecutionLogClientForExecutors,
      version: pluginContext.env.packageInfo.version,
      experimentalFeatures: config.experimentalFeatures
    };
    const queryRuleAdditionalOptions = {
      scheduleNotificationResponseActionsService: (0, _schedule_notification_response_actions.getScheduleNotificationResponseActionsService)({
        endpointAppContextService: this.endpointAppContextService,
        osqueryCreateActionService: plugins.osquery.createActionService
      })
    };
    const securityRuleTypeWrapper = (0, _create_security_rule_type_wrapper.createSecurityRuleTypeWrapper)(securityRuleTypeOptions);
    plugins.alerting.registerType(securityRuleTypeWrapper((0, _rule_types.createEqlAlertType)(ruleOptions)));
    if (!experimentalFeatures.esqlRulesDisabled) {
      plugins.alerting.registerType(securityRuleTypeWrapper((0, _rule_types.createEsqlAlertType)(ruleOptions)));
    }
    plugins.alerting.registerType(securityRuleTypeWrapper((0, _rule_types.createQueryAlertType)({
      ...ruleOptions,
      ...queryRuleAdditionalOptions,
      id: _securitysolutionRules.SAVED_QUERY_RULE_TYPE_ID,
      name: 'Saved Query Rule'
    })));
    plugins.alerting.registerType(securityRuleTypeWrapper((0, _rule_types.createIndicatorMatchAlertType)(ruleOptions)));
    plugins.alerting.registerType(securityRuleTypeWrapper((0, _rule_types.createMlAlertType)(ruleOptions)));
    plugins.alerting.registerType(securityRuleTypeWrapper((0, _rule_types.createQueryAlertType)({
      ...ruleOptions,
      ...queryRuleAdditionalOptions,
      id: _securitysolutionRules.QUERY_RULE_TYPE_ID,
      name: 'Custom Query Rule'
    })));
    plugins.alerting.registerType(securityRuleTypeWrapper((0, _rule_types.createThresholdAlertType)(ruleOptions)));
    plugins.alerting.registerType(securityRuleTypeWrapper((0, _rule_types.createNewTermsAlertType)(ruleOptions)));

    // TODO We need to get the endpoint routes inside of initRoutes
    (0, _routes.initRoutes)(router, config, ((_plugins$encryptedSav = plugins.encryptedSavedObjects) === null || _plugins$encryptedSav === void 0 ? void 0 : _plugins$encryptedSav.canEncrypt) === true, plugins.security, this.telemetryEventsSender, plugins.ml, ruleDataService, logger, ruleDataClient, ruleOptions, core.getStartServices, securityRuleTypeOptions, previewRuleDataClient, this.telemetryReceiver);
    (0, _metadata2.registerEndpointRoutes)(router, this.endpointContext);
    (0, _suggestions.registerEndpointSuggestionsRoutes)(router, plugins.unifiedSearch.autocomplete.getInitializerContextConfig().create(), this.endpointContext);
    (0, _limited_concurrency.registerLimitedConcurrencyRoutes)(core);
    (0, _policy.registerPolicyRoutes)(router, this.endpointContext);
    (0, _protection_updates_note.registerProtectionUpdatesNoteRoutes)(router, this.endpointContext);
    (0, _actions.registerActionRoutes)(router, this.endpointContext, ((_plugins$encryptedSav2 = plugins.encryptedSavedObjects) === null || _plugins$encryptedSav2 === void 0 ? void 0 : _plugins$encryptedSav2.canEncrypt) === true);
    (0, _agent.registerAgentRoutes)(router, this.endpointContext);
    if (plugins.alerting != null) {
      const ruleNotificationType = (0, _rule_actions_legacy.legacyRulesNotificationRuleType)({
        logger
      });
      if ((0, _rule_actions_legacy.isLegacyNotificationRuleExecutor)(ruleNotificationType)) {
        plugins.alerting.registerType(ruleNotificationType);
      }
    }
    const exceptionListsSetupEnabled = () => {
      return plugins.taskManager && plugins.lists;
    };
    if (exceptionListsSetupEnabled()) {
      this.lists = plugins.lists;
      this.manifestTask = new _artifacts.ManifestTask({
        endpointAppContext: this.endpointContext,
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        taskManager: plugins.taskManager
      });
    }
    if (plugins.taskManager) {
      this.completeExternalResponseActionsTask.setup({
        taskManager: plugins.taskManager
      });
    }
    core.getStartServices().then(([_, depsStart]) => {
      var _depsStart$spaces, _depsStart$spaces$spa, _depsStart$spaces2, _depsStart$spaces2$sp;
      appClientFactory.setup({
        getSpaceId: (_depsStart$spaces = depsStart.spaces) === null || _depsStart$spaces === void 0 ? void 0 : (_depsStart$spaces$spa = _depsStart$spaces.spacesService) === null || _depsStart$spaces$spa === void 0 ? void 0 : _depsStart$spaces$spa.getSpaceId,
        config,
        kibanaVersion: pluginContext.env.packageInfo.version,
        kibanaBranch: pluginContext.env.packageInfo.branch
      });
      const endpointFieldsStrategy = (0, _endpoint_fields.endpointFieldsProvider)(this.endpointAppContextService, depsStart.data.indexPatterns);
      plugins.data.search.registerSearchStrategy(_constants2.ENDPOINT_FIELDS_SEARCH_STRATEGY, endpointFieldsStrategy);
      const endpointPackagePoliciesStatsStrategy = (0, _endpoint_package_policies_stats.endpointPackagePoliciesStatsSearchStrategyProvider)(this.endpointAppContextService);
      plugins.data.search.registerSearchStrategy(_constants2.ENDPOINT_PACKAGE_POLICIES_STATS_STRATEGY, endpointPackagePoliciesStatsStrategy);
      const securitySolutionSearchStrategy = (0, _security_solution.securitySolutionSearchStrategyProvider)(depsStart.data, this.endpointContext, (_depsStart$spaces2 = depsStart.spaces) === null || _depsStart$spaces2 === void 0 ? void 0 : (_depsStart$spaces2$sp = _depsStart$spaces2.spacesService) === null || _depsStart$spaces2$sp === void 0 ? void 0 : _depsStart$spaces2$sp.getSpaceId, ruleDataClient);
      plugins.data.search.registerSearchStrategy('securitySolutionSearchStrategy', securitySolutionSearchStrategy);
      const endpointSearchStrategy = (0, _endpoint.endpointSearchStrategyProvider)(depsStart.data, this.endpointContext);
      plugins.data.search.registerSearchStrategy(_constants2.ENDPOINT_SEARCH_STRATEGY, endpointSearchStrategy);

      /**
       * Register a config for the security guide
       */
      if (depsStart.cloudExperiments && _i18n.i18n.getLocale() === 'en') {
        try {
          depsStart.cloudExperiments.getVariation('security-solutions.guided-onboarding-content', _siem_guide_config.defaultGuideTranslations).then(variation => {
            var _plugins$guidedOnboar;
            (_plugins$guidedOnboar = plugins.guidedOnboarding) === null || _plugins$guidedOnboar === void 0 ? void 0 : _plugins$guidedOnboar.registerGuideConfig(_siem_guide_config.siemGuideId, (0, _siem_guide_config.getSiemGuideConfig)(variation));
          });
        } catch {
          var _plugins$guidedOnboar2;
          (_plugins$guidedOnboar2 = plugins.guidedOnboarding) === null || _plugins$guidedOnboar2 === void 0 ? void 0 : _plugins$guidedOnboar2.registerGuideConfig(_siem_guide_config.siemGuideId, (0, _siem_guide_config.getSiemGuideConfig)(_siem_guide_config.defaultGuideTranslations));
        }
      } else {
        var _plugins$guidedOnboar3;
        (_plugins$guidedOnboar3 = plugins.guidedOnboarding) === null || _plugins$guidedOnboar3 === void 0 ? void 0 : _plugins$guidedOnboar3.registerGuideConfig(_siem_guide_config.siemGuideId, (0, _siem_guide_config.getSiemGuideConfig)(_siem_guide_config.defaultGuideTranslations));
      }
    });
    (0, _helpers.setIsElasticCloudDeployment)((_plugins$cloud$isClou = plugins.cloud.isCloudEnabled) !== null && _plugins$cloud$isClou !== void 0 ? _plugins$cloud$isClou : false);
    this.asyncTelemetryEventsSender.setup(_async_sender.DEFAULT_RETRY_CONFIG, _async_sender.DEFAULT_QUEUE_CONFIG, this.telemetryReceiver, plugins.telemetry, this.telemetryUsageCounter);
    this.telemetryEventsSender.setup(this.telemetryReceiver, plugins.telemetry, plugins.taskManager, this.telemetryUsageCounter, this.asyncTelemetryEventsSender);
    this.checkMetadataTransformsTask = new _metadata.CheckMetadataTransformsTask({
      endpointAppContext: this.endpointContext,
      core,
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      taskManager: plugins.taskManager
    });
    _feature_usage.featureUsageService.setup(plugins.licensing);
    return {
      setProductFeaturesConfigurator: productFeaturesService.setProductFeaturesConfigurator.bind(productFeaturesService),
      experimentalFeatures: {
        ...config.experimentalFeatures
      }
    };
  }
  start(core, plugins) {
    var _plugins$fleet, _this$lists, _plugins$fleet2, _plugins$fleet3;
    const {
      config,
      logger,
      productFeaturesService
    } = this;
    this.ruleMonitoringService.start(core, plugins);
    const savedObjectsClient = new _server.SavedObjectsClient(core.savedObjects.createInternalRepository());
    const registerIngestCallback = (_plugins$fleet = plugins.fleet) === null || _plugins$fleet === void 0 ? void 0 : _plugins$fleet.registerExternalCallback;
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    const exceptionListClient = this.lists.getExceptionListClient(savedObjectsClient, 'kibana',
    // execution of Lists plugin server extension points callbacks should be turned off
    // here because most of the uses of this client will be in contexts where some endpoint
    // validations (specifically those around authz) can not be done (due ot the lack of a `KibanaRequest`
    // from where authz can be derived)
    false);
    const {
      authz,
      agentService,
      packageService,
      packagePolicyService,
      agentPolicyService,
      createFilesClient,
      createFleetActionsClient
    } =
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    plugins.fleet;
    let manifestManager;
    const endpointFleetServicesFactory = new _fleet.EndpointFleetServicesFactory({
      agentService,
      packageService,
      packagePolicyService,
      agentPolicyService
    }, core.savedObjects);
    this.licensing$ = plugins.licensing.license$;

    // Assistant Tool and Feature Registration
    plugins.elasticAssistant.registerTools(_constants.APP_UI_ID, (0, _tools.getAssistantTools)());
    plugins.elasticAssistant.registerFeatures(_constants.APP_UI_ID, {
      assistantModelEvaluation: config.experimentalFeatures.assistantModelEvaluation
    });
    plugins.elasticAssistant.registerFeatures('management', {
      assistantModelEvaluation: config.experimentalFeatures.assistantModelEvaluation
    });
    if (this.lists && plugins.taskManager && plugins.fleet) {
      // Exceptions, Artifacts and Manifests start
      const taskManager = plugins.taskManager;
      const artifactClient = new _services.EndpointArtifactClient(plugins.fleet.createArtifactsClient('endpoint'));
      manifestManager = new _services.ManifestManager({
        savedObjectsClient,
        artifactClient,
        exceptionListClient,
        packagePolicyService: plugins.fleet.packagePolicyService,
        logger: this.pluginContext.logger.get('ManifestManager'),
        experimentalFeatures: config.experimentalFeatures,
        packagerTaskPackagePolicyUpdateBatchSize: config.packagerTaskPackagePolicyUpdateBatchSize,
        esClient: core.elasticsearch.client.asInternalUser,
        productFeaturesService
      });

      // Migrate artifacts to fleet and then start the manifest task after that is done
      plugins.fleet.fleetSetupCompleted().then(() => {
        if (this.manifestTask) {
          logger.info('Dependent plugin setup complete - Starting ManifestTask');
          this.manifestTask.start({
            taskManager
          });
        } else {
          logger.error(new Error('User artifacts task not available.'));
        }
        (0, _turn_off_policy_protections.turnOffPolicyProtectionsIfNotSupported)(core.elasticsearch.client.asInternalUser, endpointFleetServicesFactory.asInternalUser(), productFeaturesService, logger);
        (0, _turn_off_agent_policy_features.turnOffAgentPolicyFeatures)(endpointFleetServicesFactory.asInternalUser(), productFeaturesService, logger);
      });

      // License related start
      _license.licenseService.start(this.licensing$);
      _feature_usage.featureUsageService.start(plugins.licensing);
      this.policyWatcher = new _license_watch.PolicyWatcher(plugins.fleet.packagePolicyService, core.savedObjects, core.elasticsearch, logger);
      this.policyWatcher.start(_license.licenseService);
    }
    this.endpointAppContextService.start({
      fleetAuthzService: authz,
      createFleetFilesClient: createFilesClient,
      endpointMetadataService: new _metadata3.EndpointMetadataService(core.savedObjects, agentPolicyService, packagePolicyService, logger),
      endpointFleetServicesFactory,
      security: plugins.security,
      alerting: plugins.alerting,
      config,
      cases: plugins.cases,
      logger,
      manifestManager,
      registerIngestCallback,
      licenseService: _license.licenseService,
      exceptionListsClient: exceptionListClient,
      registerListsServerExtension: (_this$lists = this.lists) === null || _this$lists === void 0 ? void 0 : _this$lists.registerExtension,
      featureUsageService: _feature_usage.featureUsageService,
      experimentalFeatures: config.experimentalFeatures,
      messageSigningService: (_plugins$fleet2 = plugins.fleet) === null || _plugins$fleet2 === void 0 ? void 0 : _plugins$fleet2.messageSigningService,
      createFleetActionsClient,
      esClient: core.elasticsearch.client.asInternalUser,
      productFeaturesService,
      savedObjectsClient,
      connectorActions: plugins.actions
    });
    if (plugins.taskManager) {
      this.completeExternalResponseActionsTask.start({
        taskManager: plugins.taskManager,
        esClient: core.elasticsearch.client.asInternalUser
      });
    }
    this.telemetryReceiver.start(core, type => core.savedObjects.getIndexForType(type), _constants.DEFAULT_ALERTS_INDEX, this.endpointAppContextService, exceptionListClient, packageService);
    _artifact.artifactService.start(this.telemetryReceiver);
    this.asyncTelemetryEventsSender.start(plugins.telemetry);
    this.telemetryEventsSender.start(plugins.telemetry, plugins.taskManager, this.telemetryReceiver);
    const endpointPkgInstallationPromise = this.endpointContext.service.getInternalFleetServices().packages.getInstallation(_common2.FLEET_ENDPOINT_PACKAGE);
    Promise.all([endpointPkgInstallationPromise, (_plugins$fleet3 = plugins.fleet) === null || _plugins$fleet3 === void 0 ? void 0 : _plugins$fleet3.fleetSetupCompleted()]).then(([endpointPkgInstallation]) => {
      if (plugins.taskManager) {
        var _this$checkMetadataTr;
        if (endpointPkgInstallation !== null && endpointPkgInstallation !== void 0 && endpointPkgInstallation.version && (0, _package_v.isEndpointPackageV2)(endpointPkgInstallation.version)) {
          return;
        }
        (_this$checkMetadataTr = this.checkMetadataTransformsTask) === null || _this$checkMetadataTr === void 0 ? void 0 : _this$checkMetadataTr.start({
          taskManager: plugins.taskManager
        });
      }
    });
    if (registerIngestCallback) {
      registerIngestCallback('packagePolicyCreate', async packagePolicy => {
        await (0, _security_integrations.getCriblPackagePolicyPostCreateOrUpdateCallback)(core.elasticsearch.client.asInternalUser, packagePolicy, this.logger);
        return packagePolicy;
      });
      registerIngestCallback('packagePolicyUpdate', async packagePolicy => {
        await (0, _security_integrations.getCriblPackagePolicyPostCreateOrUpdateCallback)(core.elasticsearch.client.asInternalUser, packagePolicy, this.logger);
        return packagePolicy;
      });
    }
    return {};
  }
  stop() {
    var _this$policyWatcher;
    this.logger.debug('Stopping plugin');
    this.asyncTelemetryEventsSender.stop();
    this.telemetryEventsSender.stop();
    this.endpointAppContextService.stop();
    (_this$policyWatcher = this.policyWatcher) === null || _this$policyWatcher === void 0 ? void 0 : _this$policyWatcher.stop();
    this.completeExternalResponseActionsTask.stop();
    _license.licenseService.stop();
  }
}
exports.Plugin = Plugin;