"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertSavedObjectToSavedTimeline = void 0;
var _index = require("io-ts/lib/index");
var _PathReporter = require("io-ts/lib/PathReporter");
var _pipeable = require("fp-ts/lib/pipeable");
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _saved_object = require("../../../../../common/types/timeline/saved_object");
var _timeline = require("../../../../../common/api/timeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: Added to support legacy TimelineType.draft, can be removed in 7.10
const TimelineSavedObjectWithDraftRuntime = (0, _index.intersection)([(0, _index.type)({
  id: _index.string,
  version: _index.string,
  attributes: (0, _index.partial)({
    ..._saved_object.SavedObjectTimelineRuntimeType.props,
    timelineType: (0, _index.union)([_saved_object.SavedObjectTimelineTypeLiteralWithNullRt, (0, _index.literal)('draft')])
  })
}), (0, _index.partial)({
  savedObjectId: _index.string
})]);
const getTimelineTypeAndStatus = (timelineType = _saved_object.SavedObjectTimelineType.default, status = _saved_object.SavedObjectTimelineStatus.active) => {
  return {
    timelineType: savedObjectTimelineTypeToAPITimelineType(timelineType),
    status: savedObjectTimelineStatusToAPITimelineStatus(timelineType, status)
  };
};
const convertSavedObjectToSavedTimeline = savedObject => (0, _pipeable.pipe)(TimelineSavedObjectWithDraftRuntime.decode(savedObject), (0, _Either.map)(savedTimeline => {
  const attributes = {
    columns: savedTimeline.attributes.columns,
    dataProviders: savedTimeline.attributes.dataProviders,
    dataViewId: savedTimeline.attributes.dataViewId,
    description: savedTimeline.attributes.description,
    eqlOptions: savedTimeline.attributes.eqlOptions,
    eventType: savedTimeline.attributes.eventType,
    excludedRowRendererIds: savedTimeline.attributes.excludedRowRendererIds,
    favorite: savedTimeline.attributes.favorite,
    filters: savedTimeline.attributes.filters,
    indexNames: savedTimeline.attributes.indexNames,
    kqlMode: savedTimeline.attributes.kqlMode,
    kqlQuery: savedTimeline.attributes.kqlQuery,
    title: savedTimeline.attributes.title,
    templateTimelineId: savedTimeline.attributes.templateTimelineId,
    templateTimelineVersion: savedTimeline.attributes.templateTimelineVersion,
    dateRange: savedTimeline.attributes.dateRange,
    savedQueryId: savedTimeline.attributes.savedQueryId,
    created: savedTimeline.attributes.created,
    createdBy: savedTimeline.attributes.createdBy,
    updated: savedTimeline.attributes.updated,
    updatedBy: savedTimeline.attributes.updatedBy,
    ...getTimelineTypeAndStatus(savedTimeline.attributes.timelineType, savedTimeline.attributes.status),
    sort: savedTimeline.attributes.sort != null ? Array.isArray(savedTimeline.attributes.sort) ? savedTimeline.attributes.sort : [savedTimeline.attributes.sort] : [],
    savedSearchId: savedTimeline.attributes.savedSearchId
  };
  return {
    savedObjectId: savedTimeline.id,
    version: savedTimeline.version,
    ...attributes
  };
}), (0, _Either.fold)(errors => {
  throw new Error((0, _PathReporter.failure)(errors).join('\n'));
}, _function.identity));
exports.convertSavedObjectToSavedTimeline = convertSavedObjectToSavedTimeline;
function savedObjectTimelineTypeToAPITimelineType(timelineType) {
  switch (timelineType) {
    case _saved_object.SavedObjectTimelineType.template:
      return _timeline.TimelineType.template;
    case 'draft':
    default:
      return _timeline.TimelineType.default;
  }
}
function savedObjectTimelineStatusToAPITimelineStatus(timelineType, status) {
  // TODO: Added to support legacy TimelineType.draft, can be removed in 7.10
  if (timelineType === 'draft') {
    return _timeline.TimelineStatus.draft;
  }
  switch (status) {
    case _saved_object.SavedObjectTimelineStatus.draft:
      return _timeline.TimelineStatus.draft;
    case _saved_object.SavedObjectTimelineStatus.immutable:
      return _timeline.TimelineStatus.immutable;
    case _saved_object.SavedObjectTimelineStatus.active:
    default:
      return _timeline.TimelineStatus.active;
  }
}