"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.installPrepackagedTimelines = void 0;
var _path = _interopRequireWildcard(require("path"));
var _stream = require("stream");
var _import_timelines = require("../../timelines/import_timelines");
var _common = require("../../../utils/common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const installPrepackagedTimelines = async (maxTimelineImportExportSize, frameworkRequest, isImmutable, filePath, fileName) => {
  let readStream;
  const dir = (0, _path.resolve)((0, _path.join)(__dirname, filePath !== null && filePath !== void 0 ? filePath : '../../../../detection_engine/prebuilt_rules/content/prepackaged_timelines'));
  const file = fileName !== null && fileName !== void 0 ? fileName : 'index.ndjson';
  const dataPath = _path.default.join(dir, file);
  try {
    readStream = await (0, _common.getReadables)(dataPath);
  } catch (err) {
    return {
      success: false,
      success_count: 0,
      timelines_installed: 0,
      timelines_updated: 0,
      errors: [{
        error: {
          message: `read prepackaged timelines error: ${err.message}`,
          status_code: 500
        }
      }]
    };
  }
  return (0, _common.loadData)(readStream, docs => docs instanceof _stream.Readable ? (0, _import_timelines.importTimelines)(docs, maxTimelineImportExportSize, frameworkRequest, isImmutable) : Promise.reject(new Error(`read prepackaged timelines error`)));
};
exports.installPrepackagedTimelines = installPrepackagedTimelines;