"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTelemetryFilterListArtifactTaskConfig = createTelemetryFilterListArtifactTaskConfig;
var _artifact = require("../artifact");
var _filterlists = require("../filterlists");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createTelemetryFilterListArtifactTaskConfig() {
  const taskName = 'Security Solution Telemetry Filter List Artifact Task';
  const taskType = 'security:telemetry-filterlist-artifact';
  return {
    type: taskType,
    title: taskName,
    interval: '45m',
    timeout: '1m',
    version: '1.0.0',
    runTask: async (taskId, logger, _receiver, _sender, taskMetricsService, taskExecutionPeriod) => {
      const log = (0, _helpers.newTelemetryLogger)(logger.get('filterlists'));
      const trace = taskMetricsService.start(taskType);
      log.l(`Running task: ${taskId} [last: ${taskExecutionPeriod.last} - current: ${taskExecutionPeriod.current}]`);
      try {
        const artifactName = 'telemetry-filterlists-v1';
        const manifest = await _artifact.artifactService.getArtifact(artifactName);
        if (manifest.notModified) {
          log.l('No new filterlist artifact found, skipping...');
          taskMetricsService.end(trace);
          return 0;
        }
        const artifact = manifest.data;
        log.l(`New filterlist artifact: ${JSON.stringify(artifact)}`);
        _filterlists.filterList.endpointAlerts = artifact.endpoint_alerts;
        _filterlists.filterList.exceptionLists = artifact.exception_lists;
        _filterlists.filterList.prebuiltRulesAlerts = artifact.prebuilt_rules_alerts;
        taskMetricsService.end(trace);
        return 0;
      } catch (err) {
        log.l(`Failed to set telemetry filterlist artifact due to ${err.message}`);
        _filterlists.filterList.resetAllToDefault();
        taskMetricsService.end(trace, err);
        return 0;
      }
    }
  };
}