"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProductFeaturesService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _saved_objects = require("@kbn/files-plugin/server/saved_objects");
var _product_features = require("@kbn/security-solution-features/product_features");
var _common = require("../../../common");
var _product_features2 = require("./product_features");
var _security_saved_objects = require("./security_saved_objects");
var _cases_privileges = require("./cases_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ProductFeaturesService {
  constructor(logger, experimentalFeatures) {
    (0, _defineProperty2.default)(this, "securityProductFeatures", void 0);
    (0, _defineProperty2.default)(this, "casesProductFeatures", void 0);
    (0, _defineProperty2.default)(this, "securityAssistantProductFeatures", void 0);
    (0, _defineProperty2.default)(this, "productFeatures", void 0);
    (0, _defineProperty2.default)(this, "getApiActionName", apiPrivilege => `api:${_common.APP_ID}-${apiPrivilege}`);
    this.logger = logger;
    this.experimentalFeatures = experimentalFeatures;
    const securityFeature = (0, _product_features.getSecurityFeature)({
      savedObjects: _security_saved_objects.securityDefaultSavedObjects,
      experimentalFeatures: this.experimentalFeatures
    });
    this.securityProductFeatures = new _product_features2.ProductFeatures(this.logger, securityFeature.subFeaturesMap, securityFeature.baseKibanaFeature, securityFeature.baseKibanaSubFeatureIds);
    const casesFeature = (0, _product_features.getCasesFeature)({
      uiCapabilities: _cases_privileges.casesUiCapabilities,
      apiTags: _cases_privileges.casesApiTags,
      savedObjects: {
        files: _saved_objects.hiddenTypes
      }
    });
    this.casesProductFeatures = new _product_features2.ProductFeatures(this.logger, casesFeature.subFeaturesMap, casesFeature.baseKibanaFeature, casesFeature.baseKibanaSubFeatureIds);
    const assistantFeature = (0, _product_features.getAssistantFeature)();
    this.securityAssistantProductFeatures = new _product_features2.ProductFeatures(this.logger, assistantFeature.subFeaturesMap, assistantFeature.baseKibanaFeature, assistantFeature.baseKibanaSubFeatureIds);
  }
  init(featuresSetup) {
    this.securityProductFeatures.init(featuresSetup);
    this.casesProductFeatures.init(featuresSetup);
    this.securityAssistantProductFeatures.init(featuresSetup);
  }
  setProductFeaturesConfigurator(configurator) {
    const securityProductFeaturesConfig = configurator.security();
    this.securityProductFeatures.setConfig(securityProductFeaturesConfig);
    const casesProductFeaturesConfig = configurator.cases();
    this.casesProductFeatures.setConfig(casesProductFeaturesConfig);
    const securityAssistantProductFeaturesConfig = configurator.securityAssistant();
    this.securityAssistantProductFeatures.setConfig(securityAssistantProductFeaturesConfig);
    this.productFeatures = new Set(Object.freeze([...securityProductFeaturesConfig.keys(), ...casesProductFeaturesConfig.keys(), ...securityAssistantProductFeaturesConfig.keys()]));
  }
  isEnabled(productFeatureKey) {
    if (!this.productFeatures) {
      throw new Error('ProductFeatures has not yet been configured');
    }
    return this.productFeatures.has(productFeatureKey);
  }
  isActionRegistered(action) {
    return this.securityProductFeatures.isActionRegistered(action) || this.casesProductFeatures.isActionRegistered(action) || this.securityAssistantProductFeatures.isActionRegistered(action);
  }
  isApiPrivilegeEnabled(apiPrivilege) {
    return this.isActionRegistered(this.getApiActionName(apiPrivilege));
  }
  registerApiAccessControl(http) {
    // The `securitySolutionProductFeature:` prefix is used for ProductFeature based control.
    // Should be used only by routes that do not need RBAC, only direct productFeature control.
    const APP_FEATURE_TAG_PREFIX = 'securitySolutionProductFeature:';
    // The "access:securitySolution-" prefix is used for API action based control.
    // Should be used by routes that need RBAC, extending the `access:` role privilege check from the security plugin.
    // An additional check is performed to ensure the privilege has been registered by the productFeature service,
    // preventing full access (`*`) roles, such as superuser, from bypassing productFeature controls.
    const API_ACTION_TAG_PREFIX = `access:${_common.APP_ID}-`;
    http.registerOnPostAuth((request, response, toolkit) => {
      for (const tag of request.route.options.tags) {
        let isEnabled = true;
        if (tag.startsWith(APP_FEATURE_TAG_PREFIX)) {
          isEnabled = this.isEnabled(tag.substring(APP_FEATURE_TAG_PREFIX.length));
        } else if (tag.startsWith(API_ACTION_TAG_PREFIX)) {
          isEnabled = this.isApiPrivilegeEnabled(tag.substring(API_ACTION_TAG_PREFIX.length));
        }
        if (!isEnabled) {
          this.logger.warn(`Accessing disabled route "${request.url.pathname}${request.url.search}": responding with 404`);
          return response.notFound();
        }
      }
      return toolkit.next();
    });
  }
}
exports.ProductFeaturesService = ProductFeaturesService;