"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._formatPrivileges = void 0;
exports.checkAndFormatPrivileges = checkAndFormatPrivileges;
exports.hasReadWritePermissions = void 0;
var _constants = require("../../../../common/entity_analytics/asset_criticality/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const groupPrivilegesByName = privileges => {
  return privileges.reduce((acc, {
    privilege,
    authorized
  }) => {
    acc[privilege] = authorized;
    return acc;
  }, {});
};
const _formatPrivileges = privileges => {
  const clusterPrivilegesByPrivilege = groupPrivilegesByName(privileges.elasticsearch.cluster);
  const indexPrivilegesByIndex = Object.entries(privileges.elasticsearch.index).reduce((acc, [index, indexPrivileges]) => {
    acc[index] = groupPrivilegesByName(indexPrivileges);
    return acc;
  }, {});
  return {
    elasticsearch: {
      ...(Object.keys(indexPrivilegesByIndex).length > 0 ? {
        index: indexPrivilegesByIndex
      } : {}),
      ...(Object.keys(clusterPrivilegesByPrivilege).length > 0 ? {
        cluster: clusterPrivilegesByPrivilege
      } : {})
    }
  };
};
exports._formatPrivileges = _formatPrivileges;
async function checkAndFormatPrivileges({
  request,
  security,
  privilegesToCheck
}) {
  const checkPrivileges = security.authz.checkPrivilegesDynamicallyWithRequest(request);
  const {
    privileges,
    hasAllRequested
  } = await checkPrivileges(privilegesToCheck);
  return {
    privileges: _formatPrivileges(privileges),
    has_all_required: hasAllRequested,
    ...hasReadWritePermissions(privileges.elasticsearch, _constants.ASSET_CRITICALITY_INDEX_PATTERN)
  };
}
const hasReadWritePermissions = ({
  index,
  cluster
}, indexKey = '') => {
  var _index$indexKey, _index$indexKey2;
  const has = type => ({
    privilege,
    authorized
  }) => privilege === type && authorized;
  return {
    has_read_permissions: ((_index$indexKey = index[indexKey]) === null || _index$indexKey === void 0 ? void 0 : _index$indexKey.some(has('read'))) || cluster.some(has('read')),
    has_write_permissions: ((_index$indexKey2 = index[indexKey]) === null || _index$indexKey2 === void 0 ? void 0 : _index$indexKey2.some(has('write'))) || cluster.some(has('write'))
  };
};
exports.hasReadWritePermissions = hasReadWritePermissions;