"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isRiskScoreCalculationComplete = exports.getFieldForIdentifierAgg = exports.getAfterKeyForIdentifierType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFieldForIdentifierAgg = identifierType => identifierType === 'host' ? 'host.name' : 'user.name';
exports.getFieldForIdentifierAgg = getFieldForIdentifierAgg;
const getAfterKeyForIdentifierType = ({
  afterKeys,
  identifierType
}) => afterKeys[identifierType];
exports.getAfterKeyForIdentifierType = getAfterKeyForIdentifierType;
const isRiskScoreCalculationComplete = result => {
  var _result$after_keys$ho, _result$after_keys$us;
  return Object.keys((_result$after_keys$ho = result.after_keys.host) !== null && _result$after_keys$ho !== void 0 ? _result$after_keys$ho : {}).length === 0 && Object.keys((_result$after_keys$us = result.after_keys.user) !== null && _result$after_keys$us !== void 0 ? _result$after_keys$us : {}).length === 0;
};
exports.isRiskScoreCalculationComplete = isRiskScoreCalculationComplete;