"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.totalFieldsLimit = exports.riskScoreFieldMap = exports.mappingComponentName = exports.getTransformOptions = exports.getIndexPatternDataStream = void 0;
var _risk_engine = require("../../../../common/entity_analytics/risk_engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const commonRiskFields = {
  id_field: {
    type: 'keyword',
    array: false,
    required: false
  },
  id_value: {
    type: 'keyword',
    array: false,
    required: false
  },
  calculated_level: {
    type: 'keyword',
    array: false,
    required: false
  },
  calculated_score: {
    type: 'float',
    array: false,
    required: false
  },
  calculated_score_norm: {
    type: 'float',
    array: false,
    required: false
  },
  category_1_score: {
    type: 'float',
    array: false,
    required: false
  },
  category_1_count: {
    type: 'long',
    array: false,
    required: false
  },
  inputs: {
    type: 'object',
    array: true,
    required: false
  },
  'inputs.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'inputs.index': {
    type: 'keyword',
    array: false,
    required: false
  },
  'inputs.category': {
    type: 'keyword',
    array: false,
    required: false
  },
  'inputs.description': {
    type: 'keyword',
    array: false,
    required: false
  },
  'inputs.risk_score': {
    type: 'float',
    array: false,
    required: false
  },
  'inputs.timestamp': {
    type: 'date',
    array: false,
    required: false
  },
  notes: {
    type: 'keyword',
    array: false,
    required: false
  }
};
const buildIdentityRiskFields = identifierType => Object.keys(commonRiskFields).reduce((fieldMap, key) => {
  const identifierKey = `${identifierType}.risk.${key}`;
  fieldMap[identifierKey] = commonRiskFields[key];
  return fieldMap;
}, {});
const riskScoreFieldMap = exports.riskScoreFieldMap = {
  '@timestamp': {
    type: 'date',
    array: false,
    required: false
  },
  'host.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.risk': {
    type: 'object',
    array: false,
    required: false
  },
  ...buildIdentityRiskFields(_risk_engine.RiskScoreEntity.host),
  'user.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.risk': {
    type: 'object',
    array: false,
    required: false
  },
  ...buildIdentityRiskFields(_risk_engine.RiskScoreEntity.user)
};
const mappingComponentName = exports.mappingComponentName = '.risk-score-mappings';
const totalFieldsLimit = exports.totalFieldsLimit = 1000;
const getIndexPatternDataStream = namespace => ({
  template: `.${_risk_engine.riskScoreBaseIndexName}.${_risk_engine.riskScoreBaseIndexName}-${namespace}-index-template`,
  alias: `${_risk_engine.riskScoreBaseIndexName}.${_risk_engine.riskScoreBaseIndexName}-${namespace}`
});
exports.getIndexPatternDataStream = getIndexPatternDataStream;
const getTransformOptions = ({
  dest,
  source
}) => ({
  dest: {
    index: dest
  },
  frequency: '1h',
  latest: {
    sort: '@timestamp',
    unique_key: [`host.name`, `user.name`]
  },
  source: {
    index: source
  },
  sync: {
    time: {
      delay: '2s',
      field: '@timestamp'
    }
  }
});
exports.getTransformOptions = getTransformOptions;