"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRiskEngineRoutes = void 0;
var _init = require("./init");
var _enable = require("./enable");
var _disable = require("./disable");
var _status = require("./status");
var _privileges = require("./privileges");
var _settings = require("./settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRiskEngineRoutes = ({
  router,
  getStartServices
}) => {
  (0, _status.riskEngineStatusRoute)(router);
  (0, _init.riskEngineInitRoute)(router, getStartServices);
  (0, _enable.riskEngineEnableRoute)(router, getStartServices);
  (0, _disable.riskEngineDisableRoute)(router, getStartServices);
  (0, _settings.riskEngineSettingsRoute)(router);
  (0, _privileges.riskEnginePrivilegesRoute)(router, getStartServices);
};
exports.registerRiskEngineRoutes = registerRiskEngineRoutes;