"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformCSVToUpsertRecords = void 0;
var _stream = require("stream");
var _asset_criticality = require("../../../../common/entity_analytics/asset_criticality");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TransformCSVToUpsertRecords extends _stream.Transform {
  constructor() {
    super({
      objectMode: true
    });
  }
  _transform(chunk, encoding, callback) {
    try {
      const parseResult = (0, _asset_criticality.parseAssetCriticalityCsvRow)(chunk);
      if ((0, _asset_criticality.isErrorResult)(parseResult)) {
        return callback(null, new Error(parseResult.error));
      } else {
        callback(null, parseResult.record);
      }
    } catch (err) {
      // we want to handle errors gracefully and continue processing the rest of the file
      callback(null, err);
    }
  }
}
const transformCSVToUpsertRecords = () => new TransformCSVToUpsertRecords();
exports.transformCSVToUpsertRecords = transformCSVToUpsertRecords;