"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSuppressionTerms = exports.getSuppressionAlertFields = void 0;
var _pick = _interopRequireDefault(require("lodash/pick"));
var _get2 = _interopRequireDefault(require("lodash/get"));
var _sortBy = _interopRequireDefault(require("lodash/sortBy"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * returns an object containing the standard suppression fields (ALERT_INSTANCE_ID, ALERT_SUPPRESSION_TERMS, etc), with corresponding values populated from the `fields` parameter.
 */
const getSuppressionAlertFields = ({
  primaryTimestamp,
  secondaryTimestamp,
  fields,
  suppressionTerms,
  fallbackTimestamp,
  instanceId
}) => {
  var _ref, _get;
  const suppressionTime = new Date((_ref = (_get = (0, _get2.default)(fields, primaryTimestamp)) !== null && _get !== void 0 ? _get : secondaryTimestamp && (0, _get2.default)(fields, secondaryTimestamp)) !== null && _ref !== void 0 ? _ref : fallbackTimestamp);
  const suppressionFields = {
    [_ruleDataUtils.ALERT_INSTANCE_ID]: instanceId,
    [_ruleDataUtils.ALERT_SUPPRESSION_TERMS]: suppressionTerms,
    [_ruleDataUtils.ALERT_SUPPRESSION_START]: suppressionTime,
    [_ruleDataUtils.ALERT_SUPPRESSION_END]: suppressionTime,
    [_ruleDataUtils.ALERT_SUPPRESSION_DOCS_COUNT]: 0
  };
  return suppressionFields;
};

/**
 * returns an array of {@link SuppressionTerm}s by retrieving the appropriate field values based on the provided alertSuppression configuration
 */
exports.getSuppressionAlertFields = getSuppressionAlertFields;
const getSuppressionTerms = ({
  alertSuppression,
  fields
}) => {
  var _alertSuppression$gro;
  const suppressedBy = (_alertSuppression$gro = alertSuppression === null || alertSuppression === void 0 ? void 0 : alertSuppression.groupBy) !== null && _alertSuppression$gro !== void 0 ? _alertSuppression$gro : [];
  const suppressedProps = (0, _pick.default)(fields, suppressedBy);
  const suppressionTerms = suppressedBy.map(field => {
    var _suppressedProps$fiel;
    const value = (_suppressedProps$fiel = suppressedProps[field]) !== null && _suppressedProps$fiel !== void 0 ? _suppressedProps$fiel : null;
    const sortedValue = Array.isArray(value) ? (0, _sortBy.default)(value) : value;
    return {
      field,
      value: sortedValue
    };
  });
  return suppressionTerms;
};
exports.getSuppressionTerms = getSuppressionTerms;