"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldsForWildcard = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFieldsForWildcard = async ({
  index,
  dataViews,
  language,
  ruleExecutionLogger
}) => {
  if (!index || language !== 'kuery') {
    return [];
  }
  try {
    const fields = await dataViews.getFieldsForWildcard({
      pattern: index.join(),
      allowNoIndex: true
    });
    return fields;
  } catch (e) {
    ruleExecutionLogger.error(`Failed to fetch index fields: ${e === null || e === void 0 ? void 0 : e.message}`);
    return [];
  }
};
exports.getFieldsForWildcard = getFieldsForWildcard;