"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wrapSuppressedNewTermsAlerts = void 0;
var _objectHash = _interopRequireDefault(require("object-hash"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _field_names = require("../../../../../common/field_maps/field_names");
var _reason_formatters = require("../utils/reason_formatters");
var _utils = require("../utils");
var _build_bulk_body = require("../factories/utils/build_bulk_body");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const wrapSuppressedNewTermsAlerts = ({
  eventsAndTerms,
  spaceId,
  completeRule,
  mergeStrategy,
  indicesToQuery,
  alertTimestampOverride,
  ruleExecutionLogger,
  publicBaseUrl,
  primaryTimestamp,
  secondaryTimestamp
}) => {
  return eventsAndTerms.map(eventAndTerms => {
    var _completeRule$rulePar;
    const event = eventAndTerms.event;
    const suppressionTerms = (0, _utils.getSuppressionTerms)({
      alertSuppression: completeRule === null || completeRule === void 0 ? void 0 : (_completeRule$rulePar = completeRule.ruleParams) === null || _completeRule$rulePar === void 0 ? void 0 : _completeRule$rulePar.alertSuppression,
      fields: event.fields
    });
    const instanceId = (0, _objectHash.default)([suppressionTerms, completeRule.alertId, spaceId]);
    const id = (0, _objectHash.default)([eventAndTerms.event._index, eventAndTerms.event._id, String(eventAndTerms.event._version), `${spaceId}:${completeRule.alertId}`, eventAndTerms.newTerms, suppressionTerms]);
    const baseAlert = (0, _build_bulk_body.buildBulkBody)(spaceId, completeRule, event, mergeStrategy, [], true, _reason_formatters.buildReasonMessageForNewTermsAlert, indicesToQuery, alertTimestampOverride, ruleExecutionLogger, id, publicBaseUrl);
    return {
      _id: id,
      _index: '',
      _source: {
        ...baseAlert,
        [_field_names.ALERT_NEW_TERMS]: eventAndTerms.newTerms,
        ...(0, _utils.getSuppressionAlertFields)({
          primaryTimestamp,
          secondaryTimestamp,
          fields: event.fields,
          suppressionTerms,
          fallbackTimestamp: baseAlert[_ruleDataUtils.TIMESTAMP],
          instanceId
        })
      }
    };
  });
};
exports.wrapSuppressedNewTermsAlerts = wrapSuppressedNewTermsAlerts;