"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.threatEnrichmentFactory = void 0;
var _get_threat_list = require("./get_threat_list");
var _enrich_signal_threat_matches = require("./enrich_signal_threat_matches");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * returns threatEnrichment method used events-first search
 */
const threatEnrichmentFactory = ({
  signalsQueryMap,
  threatIndicatorPath,
  threatFilters,
  threatSearchParams
}) => {
  const threatEnrichment = signals => {
    const getThreats = async () => {
      const threatIds = signals.map(s => s._id).reduce((acc, id) => {
        var _signalsQueryMap$get;
        return [...new Set([...acc, ...((_signalsQueryMap$get = signalsQueryMap.get(id)) !== null && _signalsQueryMap$get !== void 0 ? _signalsQueryMap$get : []).map(threatQueryMatched => threatQueryMatched.id)])];
      }, []).flat();
      const matchedThreatsFilter = {
        query: {
          bool: {
            filter: {
              ids: {
                values: threatIds
              }
            }
          }
        }
      };
      const threatResponse = await (0, _get_threat_list.getThreatList)({
        ...threatSearchParams,
        threatListConfig: {
          _source: [`${threatIndicatorPath}.*`, 'threat.feed.*'],
          fields: undefined
        },
        threatFilters: [...threatFilters, matchedThreatsFilter],
        searchAfter: undefined
      });
      return threatResponse.hits.hits;
    };
    return (0, _enrich_signal_threat_matches.enrichSignalThreatMatchesFromSignalsMap)(signals, getThreats, threatIndicatorPath, signalsQueryMap);
  };
  return threatEnrichment;
};
exports.threatEnrichmentFactory = threatEnrichmentFactory;