"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getProcessAlerts = exports.getIsolateAlerts = exports.getErrorProcessAlerts = exports.FIELD_NOT_EXIST = void 0;
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FIELD_NOT_EXIST = field => _i18n.i18n.translate('xpack.securitySolution.responseActionsList.error.nonExistingFieldName', {
  defaultMessage: 'The action was called with a non-existing event field name: {field}',
  values: {
    field
  }
});
exports.FIELD_NOT_EXIST = FIELD_NOT_EXIST;
const getProcessAlerts = (alerts, config) => {
  if (!config) {
    return {};
  }
  const {
    overwrite,
    field
  } = config;
  return alerts.reduce((acc, alert) => {
    var _alert$process;
    const valueFromAlert = overwrite ? (_alert$process = alert.process) === null || _alert$process === void 0 ? void 0 : _alert$process.pid : (0, _lodash.get)(alert, field);
    if (valueFromAlert) {
      var _alert$host;
      const isEntityId = !overwrite && field.includes('entity_id');
      const paramKey = isEntityId ? 'entity_id' : 'pid';
      const {
        _id,
        agent
      } = alert;
      const {
        id: agentId,
        name
      } = agent;
      const hostName = (_alert$host = alert.host) === null || _alert$host === void 0 ? void 0 : _alert$host.name;
      const currentAgent = acc[agentId];
      const currentValue = currentAgent === null || currentAgent === void 0 ? void 0 : currentAgent[valueFromAlert];
      return {
        ...acc,
        [agentId]: {
          ...(currentAgent || {}),
          [valueFromAlert]: {
            ...(currentValue || {}),
            alert_ids: [...((currentValue === null || currentValue === void 0 ? void 0 : currentValue.alert_ids) || []), _id],
            parameters: {
              [paramKey]: valueFromAlert
            },
            endpoint_ids: [agentId],
            hosts: {
              ...(currentValue === null || currentValue === void 0 ? void 0 : currentValue.hosts),
              [agentId]: {
                name: name || hostName,
                id: agentId
              }
            }
          }
        }
      };
    }
    return acc;
  }, {});
};
exports.getProcessAlerts = getProcessAlerts;
const getErrorProcessAlerts = (alerts, config) => {
  if (!config) {
    return {};
  }
  const {
    overwrite,
    field
  } = config;
  return alerts.reduce((acc, alert) => {
    var _alert$process2;
    const valueFromAlert = overwrite ? (_alert$process2 = alert.process) === null || _alert$process2 === void 0 ? void 0 : _alert$process2.pid : (0, _lodash.get)(alert, field);
    if (!valueFromAlert) {
      var _alert$host2;
      const {
        _id,
        agent
      } = alert;
      const {
        id: agentId,
        name
      } = agent;
      const hostName = (_alert$host2 = alert.host) === null || _alert$host2 === void 0 ? void 0 : _alert$host2.name;
      const errorField = overwrite ? 'process.pid' : field;
      const currentAgent = acc[agentId];
      const currentValue = currentAgent === null || currentAgent === void 0 ? void 0 : currentAgent[errorField];
      return {
        ...acc,
        [agentId]: {
          ...(currentAgent || {}),
          [errorField]: {
            ...(currentValue || {}),
            alert_ids: [...((currentValue === null || currentValue === void 0 ? void 0 : currentValue.alert_ids) || []), _id],
            parameters: {},
            endpoint_ids: [agentId],
            hosts: {
              ...(currentValue === null || currentValue === void 0 ? void 0 : currentValue.hosts),
              [agentId]: {
                name: name || hostName || '',
                id: agentId
              }
            },
            error: FIELD_NOT_EXIST(errorField)
          }
        }
      };
    }
    return acc;
  }, {});
};
exports.getErrorProcessAlerts = getErrorProcessAlerts;
const getIsolateAlerts = alerts => alerts.reduce((acc, alert) => {
  var _alert$host3, _acc$agentId, _acc$agentId2;
  const {
    id: agentId,
    name: agentName
  } = alert.agent || {};
  const hostName = (_alert$host3 = alert.host) === null || _alert$host3 === void 0 ? void 0 : _alert$host3.name;
  return {
    ...acc,
    [agentId]: {
      ...((acc === null || acc === void 0 ? void 0 : acc[agentId]) || {}),
      hosts: {
        ...(((_acc$agentId = acc[agentId]) === null || _acc$agentId === void 0 ? void 0 : _acc$agentId.hosts) || {}),
        [agentId]: {
          name: agentName || hostName || '',
          id: agentId
        }
      },
      endpoint_ids: [agentId],
      alert_ids: [...(((_acc$agentId2 = acc[agentId]) === null || _acc$agentId2 === void 0 ? void 0 : _acc$agentId2.alert_ids) || []), alert._id]
    }
  };
}, {});
exports.getIsolateAlerts = getIsolateAlerts;