"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TIMESTAMP = exports.RULE_EXECUTION_UUID = exports.RULE_EXECUTION_TOTAL_DURATION_MS = exports.RULE_EXECUTION_STATUS = exports.RULE_EXECUTION_SEARCH_DURATION_MS = exports.RULE_EXECUTION_SCHEDULE_DELAY_NS = exports.RULE_EXECUTION_OUTCOME = exports.RULE_EXECUTION_INDEXING_DURATION_MS = exports.RULE_EXECUTION_GAP_DURATION_S = exports.NUMBER_OF_ALERTS_GENERATED = exports.MESSAGE = exports.LOG_LEVEL = exports.EVENT_SEQUENCE = exports.EVENT_PROVIDER = exports.EVENT_CATEGORY = exports.EVENT_ACTION = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// -------------------------------------------------------------------------------------------------
// ECS fields

const TIMESTAMP = exports.TIMESTAMP = `@timestamp`;
const MESSAGE = exports.MESSAGE = 'message';
const EVENT_PROVIDER = exports.EVENT_PROVIDER = 'event.provider';
const EVENT_ACTION = exports.EVENT_ACTION = 'event.action';
const EVENT_CATEGORY = exports.EVENT_CATEGORY = 'event.category';
const EVENT_SEQUENCE = exports.EVENT_SEQUENCE = 'event.sequence';
const LOG_LEVEL = exports.LOG_LEVEL = 'log.level';

// -------------------------------------------------------------------------------------------------
// Custom fields of Alerting Framework and Security Solution

const RULE_EXECUTION = 'kibana.alert.rule.execution';
const RULE_EXECUTION_METRICS = `${RULE_EXECUTION}.metrics`;
const RULE_EXECUTION_UUID = exports.RULE_EXECUTION_UUID = `${RULE_EXECUTION}.uuid`;
const RULE_EXECUTION_OUTCOME = exports.RULE_EXECUTION_OUTCOME = 'kibana.alerting.outcome';
const RULE_EXECUTION_STATUS = exports.RULE_EXECUTION_STATUS = `${RULE_EXECUTION}.status`;
const RULE_EXECUTION_TOTAL_DURATION_MS = exports.RULE_EXECUTION_TOTAL_DURATION_MS = `${RULE_EXECUTION_METRICS}.total_run_duration_ms`;
const RULE_EXECUTION_SEARCH_DURATION_MS = exports.RULE_EXECUTION_SEARCH_DURATION_MS = `${RULE_EXECUTION_METRICS}.total_search_duration_ms`;
const RULE_EXECUTION_INDEXING_DURATION_MS = exports.RULE_EXECUTION_INDEXING_DURATION_MS = `${RULE_EXECUTION_METRICS}.total_indexing_duration_ms`;
const RULE_EXECUTION_GAP_DURATION_S = exports.RULE_EXECUTION_GAP_DURATION_S = `${RULE_EXECUTION_METRICS}.execution_gap_duration_s`;
const RULE_EXECUTION_SCHEDULE_DELAY_NS = exports.RULE_EXECUTION_SCHEDULE_DELAY_NS = 'kibana.task.schedule_delay';
const NUMBER_OF_ALERTS_GENERATED = exports.NUMBER_OF_ALERTS_GENERATED = `${RULE_EXECUTION_METRICS}.alert_counts.new`;