"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suggestUserProfilesRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../../common/constants");
var _utils = require("../utils");
var _route_validation = require("../../../../utils/build_validation/route_validation");
var _users = require("../../../../../common/api/detection_engine/users");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const suggestUserProfilesRoute = (router, getStartServices) => {
  router.versioned.get({
    path: _constants.DETECTION_ENGINE_ALERT_SUGGEST_USERS_URL,
    access: 'public',
    options: {
      tags: ['access:securitySolution']
    }
  }).addVersion({
    version: '2023-10-31',
    validate: {
      request: {
        query: (0, _route_validation.buildRouteValidationWithZod)(_users.SuggestUserProfilesRequestQuery)
      }
    }
  }, async (context, request, response) => {
    const {
      searchTerm
    } = request.query;
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    const [_, {
      security
    }] = await getStartServices();
    const securitySolution = await context.securitySolution;
    const spaceId = securitySolution.getSpaceId();
    try {
      const users = await security.userProfiles.suggest({
        name: searchTerm,
        dataPath: 'avatar',
        requiredPrivileges: {
          spaceId,
          privileges: {
            kibana: [security.authz.actions.login]
          }
        }
      });
      return response.ok({
        body: users
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.suggestUserProfilesRoute = suggestUserProfilesRoute;