"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.installPrebuiltRulesAndTimelinesRoute = exports.createPrepackagedRules = exports.PrepackagedRulesError = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _prebuilt_rules = require("../../../../../../common/api/detection_engine/prebuilt_rules");
var _utils = require("../../../routes/utils");
var _get_existing_prepackaged_rules = require("../../../rule_management/logic/search/get_existing_prepackaged_rules");
var _constants = require("../../constants");
var _ensure_latest_rules_package_installed = require("../../logic/ensure_latest_rules_package_installed");
var _get_rules_to_install = require("../../logic/get_rules_to_install");
var _get_rules_to_update = require("../../logic/get_rules_to_update");
var _perform_timelines_installation = require("../../logic/perform_timelines_installation");
var _prebuilt_rule_assets_client = require("../../logic/rule_assets/prebuilt_rule_assets_client");
var _create_prebuilt_rules = require("../../logic/rule_objects/create_prebuilt_rules");
var _upgrade_prebuilt_rules = require("../../logic/rule_objects/upgrade_prebuilt_rules");
var _utils2 = require("../../logic/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const installPrebuiltRulesAndTimelinesRoute = router => {
  router.versioned.put({
    access: 'public',
    path: _prebuilt_rules.PREBUILT_RULES_URL,
    options: {
      tags: ['access:securitySolution'],
      timeout: {
        idleSocket: _constants.PREBUILT_RULES_OPERATION_SOCKET_TIMEOUT_MS
      }
    }
  }).addVersion({
    version: '2023-10-31',
    validate: false
  }, async (context, _, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const rulesClient = (await context.alerting).getRulesClient();
      const validated = await createPrepackagedRules(await context.securitySolution, rulesClient, undefined);
      return response.ok({
        body: validated !== null && validated !== void 0 ? validated : {}
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.installPrebuiltRulesAndTimelinesRoute = installPrebuiltRulesAndTimelinesRoute;
class PrepackagedRulesError extends Error {
  constructor(message, statusCode) {
    super(message);
    (0, _defineProperty2.default)(this, "statusCode", void 0);
    this.statusCode = statusCode;
  }
}
exports.PrepackagedRulesError = PrepackagedRulesError;
const createPrepackagedRules = async (context, rulesClient, exceptionsClient) => {
  var _context$getException, _timelinesResult$time, _timelinesResult$time2;
  const config = context.getConfig();
  const savedObjectsClient = context.core.savedObjects.client;
  const siemClient = context.getAppClient();
  const exceptionsListClient = (_context$getException = context.getExceptionListClient()) !== null && _context$getException !== void 0 ? _context$getException : exceptionsClient;
  const ruleAssetsClient = (0, _prebuilt_rule_assets_client.createPrebuiltRuleAssetsClient)(savedObjectsClient);
  if (!siemClient || !rulesClient) {
    throw new PrepackagedRulesError('', 404);
  }

  // This will create the endpoint list if it does not exist yet
  if (exceptionsListClient != null) {
    await exceptionsListClient.createEndpointList();
  }
  const latestPrebuiltRules = await (0, _ensure_latest_rules_package_installed.ensureLatestRulesPackageInstalled)(ruleAssetsClient, config, context);
  const installedPrebuiltRules = (0, _utils2.rulesToMap)(await (0, _get_existing_prepackaged_rules.getExistingPrepackagedRules)({
    rulesClient
  }));
  const rulesToInstall = (0, _get_rules_to_install.getRulesToInstall)(latestPrebuiltRules, installedPrebuiltRules);
  const rulesToUpdate = (0, _get_rules_to_update.getRulesToUpdate)(latestPrebuiltRules, installedPrebuiltRules);
  const result = await (0, _create_prebuilt_rules.createPrebuiltRules)(rulesClient, rulesToInstall);
  if (result.errors.length > 0) {
    throw new AggregateError(result.errors, 'Error installing new prebuilt rules');
  }
  const {
    result: timelinesResult
  } = await (0, _perform_timelines_installation.performTimelinesInstallation)(context);
  await (0, _upgrade_prebuilt_rules.upgradePrebuiltRules)(rulesClient, rulesToUpdate);
  const prebuiltRulesOutput = {
    rules_installed: rulesToInstall.length,
    rules_updated: rulesToUpdate.length,
    timelines_installed: (_timelinesResult$time = timelinesResult === null || timelinesResult === void 0 ? void 0 : timelinesResult.timelines_installed) !== null && _timelinesResult$time !== void 0 ? _timelinesResult$time : 0,
    timelines_updated: (_timelinesResult$time2 = timelinesResult === null || timelinesResult === void 0 ? void 0 : timelinesResult.timelines_updated) !== null && _timelinesResult$time2 !== void 0 ? _timelinesResult$time2 : 0
  };
  return _prebuilt_rules.InstallPrebuiltRulesAndTimelinesResponse.parse(prebuiltRulesOutput);
};
exports.createPrepackagedRules = createPrepackagedRules;