"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateEndpointPackagePolicy = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _controlled_artifact_rollout = require("../../../common/endpoint/utils/controlled_artifact_rollout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateEndpointPackagePolicy = inputs => {
  var _input$config, _input$config$policy, _input$config$policy$;
  const input = inputs.find(i => i.type === 'endpoint');
  if (input !== null && input !== void 0 && (_input$config = input.config) !== null && _input$config !== void 0 && (_input$config$policy = _input$config.policy) !== null && _input$config$policy !== void 0 && (_input$config$policy$ = _input$config$policy.value) !== null && _input$config$policy$ !== void 0 && _input$config$policy$.global_manifest_version) {
    const globalManifestVersion = input.config.policy.value.global_manifest_version;
    if (globalManifestVersion !== 'latest') {
      const parsedDate = _moment.default.utc(globalManifestVersion, 'YYYY-MM-DD', true);
      if (!parsedDate.isValid()) {
        throw createManifestVersionError('Invalid date format. Use "latest" or "YYYY-MM-DD" format. UTC time.');
      }
      const maxAllowedDate = (0, _controlled_artifact_rollout.getControlledArtifactCutoffDate)();
      if (parsedDate.isBefore(maxAllowedDate)) {
        throw createManifestVersionError('Global manifest version is too far in the past. Please use either "latest" or a date within the last 18 months. The earliest valid date is October 1, 2023, in UTC time.');
      }
      const minAllowedDate = _moment.default.utc().subtract(1, 'day');
      if (parsedDate.isAfter(minAllowedDate)) {
        throw createManifestVersionError(`Global manifest version cannot be in the future. Latest selectable date is ${minAllowedDate.format('MMMM DD, YYYY')} UTC time.`);
      }
    }
  }
};
exports.validateEndpointPackagePolicy = validateEndpointPackagePolicy;
const createManifestVersionError = message => {
  const manifestVersionError = new Error(message);
  manifestVersionError.statusCode = 400;
  manifestVersionError.apiPassThrough = true;
  return manifestVersionError;
};