"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getResponseActionsClient = void 0;
var _endpoint_actions_client = require("./endpoint/endpoint_actions_client");
var _sentinel_one_actions_client = require("./sentinelone/sentinel_one_actions_client");
var _errors = require("./errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Retrieve a response actions client for an agent type
 * @param agentType
 * @param constructorOptions
 *
 * @throws UnsupportedResponseActionsAgentTypeError
 */
const getResponseActionsClient = (agentType, constructorOptions) => {
  switch (agentType) {
    case 'endpoint':
      return new _endpoint_actions_client.EndpointActionsClient(constructorOptions);
    case 'sentinel_one':
      return new _sentinel_one_actions_client.SentinelOneActionsClient(constructorOptions);
  }
  throw new _errors.UnsupportedResponseActionsAgentTypeError(`Agent type [${agentType}] does not support response actions`);
};
exports.getResponseActionsClient = getResponseActionsClient;