"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESQL_KNOWLEDGE_BASE_TOOL = void 0;
var _tools = require("@langchain/core/tools");
var _common = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toolDetails = {
  description: 'Call this for knowledge on how to build an ESQL query, or answer questions about the ES|QL query language. Input must always be the query on a single line, with no other text. Only output valid ES|QL queries as described above. Do not add any additional text to describe your output.',
  id: 'esql-knowledge-base-tool',
  name: 'ESQLKnowledgeBaseTool'
};
const ESQL_KNOWLEDGE_BASE_TOOL = exports.ESQL_KNOWLEDGE_BASE_TOOL = {
  ...toolDetails,
  sourceRegister: _common.APP_UI_ID,
  isSupported: params => {
    const {
      chain,
      isEnabledKnowledgeBase,
      modelExists
    } = params;
    return isEnabledKnowledgeBase && modelExists && chain != null;
  },
  getTool(params) {
    if (!this.isSupported(params)) return null;
    const {
      chain
    } = params;
    if (chain == null) return null;
    return new _tools.DynamicTool({
      name: toolDetails.name,
      description: toolDetails.description,
      func: async (input, _, cbManager) => {
        const result = await chain.invoke({
          query: input
        }, cbManager);
        return result.text;
      },
      tags: ['esql', 'query-generation', 'knowledge-base']
    });
  }
};