"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getReplacementsRecords = exports.getReplacementsArray = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getReplacementsRecords = replacements => replacements.reduce((acc, {
  value,
  uuid
}) => ({
  ...acc,
  [uuid]: value
}), {});
exports.getReplacementsRecords = getReplacementsRecords;
const getReplacementsArray = replacements => Object.entries(replacements).map(([uuid, value]) => ({
  uuid,
  value
}));
exports.getReplacementsArray = getReplacementsArray;