"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ALERT_COUNTS_TOOL_DESCRIPTION = exports.ALERT_COUNTS_TOOL = void 0;
var _tools = require("@langchain/core/tools");
var _helpers = require("@kbn/elastic-assistant-plugin/server/lib/langchain/helpers");
var _get_alert_counts_query = require("./get_alert_counts_query");
var _common = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERT_COUNTS_TOOL_DESCRIPTION = exports.ALERT_COUNTS_TOOL_DESCRIPTION = 'Call this for the counts of last 24 hours of open and acknowledged alerts in the environment, grouped by their severity and workflow status.';
const ALERT_COUNTS_TOOL = exports.ALERT_COUNTS_TOOL = {
  id: 'alert-counts-tool',
  name: 'AlertCountsTool',
  description: ALERT_COUNTS_TOOL_DESCRIPTION,
  sourceRegister: _common.APP_UI_ID,
  isSupported: params => {
    const {
      request,
      alertsIndexPattern
    } = params;
    return (0, _helpers.requestHasRequiredAnonymizationParams)(request) && alertsIndexPattern != null;
  },
  getTool(params) {
    if (!this.isSupported(params)) return null;
    const {
      alertsIndexPattern,
      esClient
    } = params;
    return new _tools.DynamicTool({
      name: 'AlertCountsTool',
      description: ALERT_COUNTS_TOOL_DESCRIPTION,
      func: async () => {
        const query = (0, _get_alert_counts_query.getAlertsCountQuery)(alertsIndexPattern);
        const result = await esClient.search(query);
        return JSON.stringify(result);
      },
      tags: ['alerts', 'alerts-count']
    });
  }
};