"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timelineByIdSelector = exports.selectTitleByTimelineById = exports.selectTimelineESQLSavedSearchId = exports.selectTimelineById = exports.selectTimeline = exports.selectKqlQuery = exports.selectKqlFilterQueryExpression = exports.selectInsertTimeline = exports.selectDataInTimeline = exports.getTimelineShowStatusByIdSelector = exports.getTimelineByIdSelector = exports.getShowCallOutUnauthorizedMsg = exports.getKqlFilterQuerySelector = exports.getKqlFilterKuerySelector = exports.dataProviderVisibilitySelector = void 0;
var _reselect = require("reselect");
var _fp = require("lodash/fp");
var _translations = require("../components/timeline/properties/translations");
var _ = require(".");
var _types = require("../../../common/types");
var _timeline = require("../../../common/api/timeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTimelineShowStatusByIdSelector = () => (0, _reselect.createSelector)(_.timelineSelectors.selectTimeline, timeline => {
  var _timeline$activeTab, _timeline$status, _timeline$show, _timeline$updated, _timeline$changed;
  return {
    activeTab: (_timeline$activeTab = timeline === null || timeline === void 0 ? void 0 : timeline.activeTab) !== null && _timeline$activeTab !== void 0 ? _timeline$activeTab : _types.TimelineTabs.query,
    status: (_timeline$status = timeline === null || timeline === void 0 ? void 0 : timeline.status) !== null && _timeline$status !== void 0 ? _timeline$status : _timeline.TimelineStatus.draft,
    show: (_timeline$show = timeline === null || timeline === void 0 ? void 0 : timeline.show) !== null && _timeline$show !== void 0 ? _timeline$show : false,
    updated: (_timeline$updated = timeline === null || timeline === void 0 ? void 0 : timeline.updated) !== null && _timeline$updated !== void 0 ? _timeline$updated : undefined,
    changed: (_timeline$changed = timeline === null || timeline === void 0 ? void 0 : timeline.changed) !== null && _timeline$changed !== void 0 ? _timeline$changed : false
  };
});

/**
 * @deprecated
 */
exports.getTimelineShowStatusByIdSelector = getTimelineShowStatusByIdSelector;
const timelineByIdState = state => state.timeline.timelineById;
const selectCallOutUnauthorizedMsg = state => state.timeline.showCallOutUnauthorizedMsg;

/**
 * @deprecated prefer using selectTimelineById below
 */
const selectTimeline = (state, timelineId) => state.timeline.timelineById[timelineId];
exports.selectTimeline = selectTimeline;
const selectInsertTimeline = state => state.timeline.insertTimeline;

/**
 * @deprecated prefer using selectTimelineById below
 */
exports.selectInsertTimeline = selectInsertTimeline;
const timelineByIdSelector = exports.timelineByIdSelector = (0, _reselect.createSelector)(timelineByIdState, timelineById => timelineById);
const getShowCallOutUnauthorizedMsg = () => (0, _reselect.createSelector)(selectCallOutUnauthorizedMsg, showCallOutUnauthorizedMsg => showCallOutUnauthorizedMsg);
exports.getShowCallOutUnauthorizedMsg = getShowCallOutUnauthorizedMsg;
const getTimelineByIdSelector = () => (0, _reselect.createSelector)(selectTimeline, timeline => timeline);
exports.getTimelineByIdSelector = getTimelineByIdSelector;
const getKqlFilterQuerySelector = () => (0, _reselect.createSelector)(selectTimeline, timeline => timeline && timeline.kqlQuery && timeline.kqlQuery.filterQuery && timeline.kqlQuery.filterQuery.kuery ? timeline.kqlQuery.filterQuery.kuery.expression : null);
exports.getKqlFilterQuerySelector = getKqlFilterQuerySelector;
const getKqlFilterKuerySelector = () => (0, _reselect.createSelector)(selectTimeline, timeline => timeline && timeline.kqlQuery && timeline.kqlQuery.filterQuery && timeline.kqlQuery.filterQuery.kuery ? timeline.kqlQuery.filterQuery.kuery : null);
exports.getKqlFilterKuerySelector = getKqlFilterKuerySelector;
const dataProviderVisibilitySelector = () => (0, _reselect.createSelector)(selectTimeline, timeline => timeline.isDataProviderVisible);

/**
 * Selector that returns the timelineById slice of state
 */
exports.dataProviderVisibilitySelector = dataProviderVisibilitySelector;
const selectTimelineById = exports.selectTimelineById = (0, _reselect.createSelector)(state => state.timeline.timelineById, (state, timelineId) => timelineId, (timelineById, timelineId) => timelineById[timelineId]);

/**
 * Selector that returns the timeline dataProviders.
 */
const selectTimelineDataProviders = (0, _reselect.createSelector)(selectTimelineById, timeline => timeline === null || timeline === void 0 ? void 0 : timeline.dataProviders);

/**
 * Selector that returns the timeline saved title.
 */
const selectTimelineTitle = (0, _reselect.createSelector)(selectTimelineById, timeline => timeline === null || timeline === void 0 ? void 0 : timeline.title);

/**
 * Selector that returns the timeline type.
 */
const selectTimelineType = (0, _reselect.createSelector)(selectTimelineById, timeline => timeline === null || timeline === void 0 ? void 0 : timeline.timelineType);

/**
 * Selector that returns the timeline kqlQuery.
 */
const selectTimelineKqlQuery = (0, _reselect.createSelector)(selectTimelineById, timeline => timeline === null || timeline === void 0 ? void 0 : timeline.kqlQuery);

/**
 * Selector that returns the timeline esql saved search id.
 */
const selectTimelineESQLSavedSearchId = exports.selectTimelineESQLSavedSearchId = (0, _reselect.createSelector)(selectTimelineById, timeline => timeline === null || timeline === void 0 ? void 0 : timeline.savedSearchId);

/**
 * Selector that returns the kqlQuery.filterQuery.kuery.expression of a timeline.
 */
const selectKqlFilterQueryExpression = exports.selectKqlFilterQueryExpression = (0, _reselect.createSelector)(selectTimelineById, timeline => {
  var _timeline$kqlQuery, _timeline$kqlQuery$fi, _timeline$kqlQuery$fi2;
  return timeline === null || timeline === void 0 ? void 0 : (_timeline$kqlQuery = timeline.kqlQuery) === null || _timeline$kqlQuery === void 0 ? void 0 : (_timeline$kqlQuery$fi = _timeline$kqlQuery.filterQuery) === null || _timeline$kqlQuery$fi === void 0 ? void 0 : (_timeline$kqlQuery$fi2 = _timeline$kqlQuery$fi.kuery) === null || _timeline$kqlQuery$fi2 === void 0 ? void 0 : _timeline$kqlQuery$fi2.expression;
});

/**
 * Selector that returns the title of a timeline.
 * If the timeline has been saved, it will return the saved title.
 * If timeline is in template mode, it will return the default 'Untitled template' value;
 * If none of the above, it will return the default 'Untitled timeline' value.
 */
const selectTitleByTimelineById = exports.selectTitleByTimelineById = (0, _reselect.createSelector)(selectTimelineTitle, selectTimelineType, (savedTitle, timelineType) => {
  if (!(0, _fp.isEmpty)(savedTitle)) {
    return savedTitle;
  }
  if (timelineType === _timeline.TimelineType.template) {
    return _translations.UNTITLED_TEMPLATE;
  }
  return _translations.UNTITLED_TIMELINE;
});

/**
 * Selector that returns the timeline query in a {@link Query} format.
 */
const selectKqlQuery = exports.selectKqlQuery = (0, _reselect.createSelector)(selectTimelineDataProviders, selectKqlFilterQueryExpression, selectTimelineType, (dataProviders, kqlFilterQueryExpression, timelineType) => {
  const kqlQueryExpression = (0, _fp.isEmpty)(dataProviders) && (0, _fp.isEmpty)(kqlFilterQueryExpression) && timelineType === 'template' ? ' ' : kqlFilterQueryExpression !== null && kqlFilterQueryExpression !== void 0 ? kqlFilterQueryExpression : '';
  return {
    query: kqlQueryExpression,
    language: 'kuery'
  };
});

/**
 * Selector that returns true if the timeline has data providers or a kqlQuery filterQuery expression.
 */
const selectDataInTimeline = exports.selectDataInTimeline = (0, _reselect.createSelector)(selectTimelineDataProviders, selectTimelineKqlQuery, (dataProviders, kqlQuery) => {
  return !(0, _fp.isEmpty)(dataProviders) || !(0, _fp.isEmpty)((0, _fp.get)('filterQuery.kuery.expression', kqlQuery));
});