"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.favoriteTimelineMiddleware = void 0;
var _fp = require("lodash/fp");
var _actions = require("../actions");
var _timeline = require("../../../../common/api/timeline");
var _api = require("../../containers/api");
var _selectors = require("../selectors");
var i18n = _interopRequireWildcard(require("../../pages/translations"));
var _helpers = require("./helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isFavoriteTimelineAction(action) {
  return action.type === _actions.updateIsFavorite.type;
}
const favoriteTimelineMiddleware = kibana => store => next => async action => {
  // perform the action
  const ret = next(action);
  if (isFavoriteTimelineAction(action)) {
    const {
      id
    } = action.payload;
    const timeline = (0, _selectors.selectTimelineById)(store.getState(), id);
    store.dispatch((0, _actions.startTimelineSaving)({
      id
    }));
    try {
      var _timeline$timelineTyp;
      const result = await (0, _api.persistFavorite)({
        timelineId: timeline.id,
        templateTimelineId: timeline.templateTimelineId,
        templateTimelineVersion: timeline.templateTimelineVersion,
        timelineType: (_timeline$timelineTyp = timeline.timelineType) !== null && _timeline$timelineTyp !== void 0 ? _timeline$timelineTyp : _timeline.TimelineType.default
      });
      const response = (0, _fp.get)('data.persistFavorite', result);
      if (response.code === 403) {
        store.dispatch((0, _actions.showCallOutUnauthorizedMsg)());
      }
      (0, _helpers.refreshTimelines)(store.getState());
      store.dispatch((0, _actions.updateTimeline)({
        id,
        timeline: {
          ...timeline,
          isFavorite: response.favorite != null && response.favorite.length > 0,
          savedObjectId: response.savedObjectId || null,
          version: response.version || null
        }
      }));
    } catch (error) {
      var _error$message;
      kibana.notifications.toasts.addDanger({
        title: i18n.UPDATE_TIMELINE_ERROR_TITLE,
        text: (_error$message = error === null || error === void 0 ? void 0 : error.message) !== null && _error$message !== void 0 ? _error$message : i18n.UPDATE_TIMELINE_ERROR_TEXT
      });
    } finally {
      store.dispatch((0, _actions.endTimelineSaving)({
        id
      }));
    }
  }
  return ret;
};
exports.favoriteTimelineMiddleware = favoriteTimelineMiddleware;