"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelinesPage = exports.DEFAULT_SEARCH_RESULTS_PER_PAGE = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _new_timeline = require("../components/new_timeline");
var _timeline = require("../../../common/api/timeline");
var _header_page = require("../../common/components/header_page");
var _page_wrapper = require("../../common/components/page_wrapper");
var _kibana = require("../../common/lib/kibana");
var _spy_routes = require("../../common/utils/route/spy_routes");
var _open_timeline = require("../components/open_timeline");
var i18n = _interopRequireWildcard(require("./translations"));
var _types = require("../../app/types");
var _sourcerer = require("../../common/containers/sourcerer");
var _empty_prompt = require("../../common/components/empty_prompt");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_SEARCH_RESULTS_PER_PAGE = exports.DEFAULT_SEARCH_RESULTS_PER_PAGE = 10;
const TimelinesPage = exports.TimelinesPage = /*#__PURE__*/_react.default.memo(() => {
  var _useKibana$services, _useKibana$services$a, _useKibana$services$a2, _useKibana$services$a3;
  const {
    tabName
  } = (0, _reactRouterDom.useParams)();
  const {
    indicesExist
  } = (0, _sourcerer.useSourcererDataView)();
  const capabilitiesCanUserCRUD = !!((_useKibana$services = (0, _kibana.useKibana)().services) !== null && _useKibana$services !== void 0 && (_useKibana$services$a = _useKibana$services.application) !== null && _useKibana$services$a !== void 0 && (_useKibana$services$a2 = _useKibana$services$a.capabilities) !== null && _useKibana$services$a2 !== void 0 && (_useKibana$services$a3 = _useKibana$services$a2.siem) !== null && _useKibana$services$a3 !== void 0 && _useKibana$services$a3.crud);
  const [isImportDataModalOpen, setImportDataModal] = (0, _react.useState)(false);
  const openImportModal = (0, _react.useCallback)(() => {
    setImportDataModal(true);
  }, [setImportDataModal]);
  const timelineType = tabName === _timeline.TimelineType.default ? _timeline.TimelineType.default : _timeline.TimelineType.template;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indicesExist ? /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, null, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: i18n.PAGE_TITLE
  }, capabilitiesCanUserCRUD && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "indexOpen",
    onClick: openImportModal,
    "data-test-subj": "timelines-page-open-import-data"
  }, i18n.ALL_TIMELINES_IMPORT_TIMELINE_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "timelines-page-new"
  }, /*#__PURE__*/_react.default.createElement(_new_timeline.NewTimelineButton, {
    type: timelineType
  })))), /*#__PURE__*/_react.default.createElement(_open_timeline.StatefulOpenTimeline, {
    defaultPageSize: DEFAULT_SEARCH_RESULTS_PER_PAGE,
    isModal: false,
    importDataModalToggle: isImportDataModalOpen && capabilitiesCanUserCRUD,
    setImportDataModalToggle: setImportDataModal,
    title: i18n.ALL_TIMELINES_PANEL_TITLE,
    "data-test-subj": "stateful-open-timeline"
  })) : /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, null), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.timelines
  }));
});
TimelinesPage.displayName = 'TimelinesPage';