"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateTimeline = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _constants = require("../../common/store/inputs/constants");
var _default_headers = require("../components/timeline/body/column_headers/default_headers");
var _store = require("../store");
var _use_full_screen = require("../../common/containers/use_full_screen");
var _timeline = require("../../../common/types/timeline");
var _use_selector = require("../../common/hooks/use_selector");
var _inputs = require("../../common/store/inputs");
var _sourcerer = require("../../common/store/sourcerer");
var _model = require("../../common/store/sourcerer/model");
var _app = require("../../common/store/app");
var _use_discover_in_timeline_context = require("../../common/components/discover_in_timeline/use_discover_in_timeline_context");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
var _default_headers2 = require("../components/timeline/unified_components/default_headers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates a new empty timeline for the given id and type.
 * Can be used to create new timelines or to reset timeline state.
 * It allows a callback to be passed in to be called when the timeline is created.
 */
const useCreateTimeline = ({
  timelineId,
  timelineType,
  onClick
}) => {
  var _useSelector;
  const dispatch = (0, _reactRedux.useDispatch)();
  const unifiedComponentsInTimelineEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('unifiedComponentsInTimelineEnabled');
  const {
    id: dataViewId,
    patternList: selectedPatterns
  } = (_useSelector = (0, _reactRedux.useSelector)(_sourcerer.sourcererSelectors.defaultDataView)) !== null && _useSelector !== void 0 ? _useSelector : {
    id: '',
    patternList: []
  };
  const {
    timelineFullScreen,
    setTimelineFullScreen
  } = (0, _use_full_screen.useTimelineFullScreen)();
  const globalTimeRange = (0, _use_selector.useDeepEqualSelector)(_inputs.inputsSelectors.globalTimeRangeSelector);
  const {
    resetDiscoverAppState
  } = (0, _use_discover_in_timeline_context.useDiscoverInTimelineContext)();
  const createTimeline = (0, _react.useCallback)(({
    id,
    show,
    timeRange: timeRangeParam
  }) => {
    const timerange = timeRangeParam !== null && timeRangeParam !== void 0 ? timeRangeParam : globalTimeRange;
    if (id === _timeline.TimelineId.active && timelineFullScreen) {
      setTimelineFullScreen(false);
    }
    dispatch(_sourcerer.sourcererActions.setSelectedDataView({
      id: _model.SourcererScopeName.timeline,
      selectedDataViewId: dataViewId,
      selectedPatterns
    }));
    dispatch(_store.timelineActions.createTimeline({
      columns: unifiedComponentsInTimelineEnabled ? _default_headers2.defaultUdtHeaders : _default_headers.defaultHeaders,
      dataViewId,
      id,
      indexNames: selectedPatterns,
      show,
      timelineType,
      updated: undefined
    }));
    dispatch(_inputs.inputsActions.addLinkTo([_constants.InputsModelId.global, _constants.InputsModelId.timeline]));
    dispatch(_app.appActions.addNotes({
      notes: []
    }));
    if (timeRangeParam) {
      dispatch(_inputs.inputsActions.removeLinkTo([_constants.InputsModelId.timeline, _constants.InputsModelId.global]));
    }
    if ((timerange === null || timerange === void 0 ? void 0 : timerange.kind) === 'absolute') {
      dispatch(_inputs.inputsActions.setAbsoluteRangeDatePicker({
        ...timerange,
        id: _constants.InputsModelId.timeline
      }));
    } else if ((timerange === null || timerange === void 0 ? void 0 : timerange.kind) === 'relative') {
      dispatch(_inputs.inputsActions.setRelativeRangeDatePicker({
        ...timerange,
        id: _constants.InputsModelId.timeline
      }));
    }
  }, [dispatch, globalTimeRange, dataViewId, selectedPatterns, setTimelineFullScreen, timelineFullScreen, timelineType, unifiedComponentsInTimelineEnabled]);
  return (0, _react.useCallback)(async options => {
    await resetDiscoverAppState();
    createTimeline({
      id: timelineId,
      show: true,
      timelineType,
      timeRange: options === null || options === void 0 ? void 0 : options.timeRange
    });
    if (typeof onClick === 'function') {
      onClick();
    }
  }, [createTimeline, timelineId, timelineType, onClick, resetDiscoverAppState]);
};
exports.useCreateTimeline = useCreateTimeline;