"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultUdtHeaders = exports.defaultColumnHeaderType = void 0;
var _constants = require("../body/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultColumnHeaderType = exports.defaultColumnHeaderType = 'not-filtered';
const defaultUdtHeaders = exports.defaultUdtHeaders = [{
  columnHeaderType: defaultColumnHeaderType,
  id: '@timestamp',
  initialWidth: _constants.DEFAULT_UNIFIED_TABLE_DATE_COLUMN_MIN_WIDTH,
  esTypes: ['date'],
  type: 'date'
}, {
  columnHeaderType: defaultColumnHeaderType,
  id: 'message',
  initialWidth: _constants.DEFAULT_COLUMN_MIN_WIDTH * 2
}, {
  columnHeaderType: defaultColumnHeaderType,
  id: 'event.category'
}, {
  columnHeaderType: defaultColumnHeaderType,
  id: 'event.action'
}, {
  columnHeaderType: defaultColumnHeaderType,
  id: 'host.name'
}, {
  columnHeaderType: defaultColumnHeaderType,
  id: 'source.ip'
}, {
  columnHeaderType: defaultColumnHeaderType,
  id: 'destination.ip'
}, {
  columnHeaderType: defaultColumnHeaderType,
  id: 'user.name'
}];