"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VerticalRule = exports.TabHeaderContainer = exports.StyledEuiFlyoutHeader = exports.StyledEuiFlyoutFooter = exports.StyledEuiFlyoutBody = exports.SourcererFlex = exports.ScrollableFlexItem = exports.FullWidthFlexGroup = exports.EventsCountBadge = void 0;
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TabHeaderContainer = exports.TabHeaderContainer = _styledComponents.default.div`
  margin-top: ${props => props.theme.eui.euiSizeS};
  width: 100%;
`;
TabHeaderContainer.displayName = 'TimelineHeaderContainer';
const StyledEuiFlyoutHeader = exports.StyledEuiFlyoutHeader = (0, _styledComponents.default)(_eui.EuiFlyoutHeader)`
  align-items: stretch;
  box-shadow: none;
  display: flex;
  flex-direction: column;
  padding: 0;

  &.euiFlyoutHeader {
    ${({
  theme
}) => `padding: ${theme.eui.euiSizeS} 0 0 0;`}
  }
`;
const StyledEuiFlyoutBody = exports.StyledEuiFlyoutBody = (0, _styledComponents.default)(_eui.EuiFlyoutBody)`
  overflow-y: hidden;
  flex: 1;

  .euiFlyoutBody__overflow {
    overflow: hidden;
    mask-image: none;
  }

  .euiFlyoutBody__overflowContent {
    padding: 0;
    height: 100%;
    display: flex;
  }
`;
const StyledEuiFlyoutFooter = exports.StyledEuiFlyoutFooter = (0, _styledComponents.default)(_eui.EuiFlyoutFooter)`
  background: none;
  &.euiFlyoutFooter {
    ${({
  theme
}) => `padding: ${theme.eui.euiSizeS} 0;`}
  }
`;
const FullWidthFlexGroup = exports.FullWidthFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin: 0;
  width: 100%;
  overflow: hidden;
`;
const ScrollableFlexItem = exports.ScrollableFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  ${({
  theme
}) => `margin: 0 ${theme.eui.euiSizeM};`}
  overflow: hidden;
`;
const SourcererFlex = exports.SourcererFlex = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  align-items: flex-end;
`;
SourcererFlex.displayName = 'SourcererFlex';
const VerticalRule = exports.VerticalRule = _styledComponents.default.div`
  width: 2px;
  height: 100%;
  background: ${({
  theme
}) => theme.eui.euiColorLightShade};
`;
VerticalRule.displayName = 'VerticalRule';
const EventsCountBadge = exports.EventsCountBadge = (0, _styledComponents.default)(_eui.EuiBadge)`
  margin-left: ${({
  theme
}) => theme.eui.euiSizeS};
`;