"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryTabHeader = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionTGrid = require("@kbn/securitysolution-t-grid");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _uiTheme = require("@kbn/ui-theme");
var _timeline = require("../../../../../../../common/api/timeline");
var _store = require("../../../../../store");
var _use_selector = require("../../../../../../common/hooks/use_selector");
var _defaults = require("../../../../../store/defaults");
var i18n = _interopRequireWildcard(require("./translations"));
var _search_or_filter = require("../../../search_or_filter");
var _data_providers = require("../../../data_providers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataProvidersContainer = _styled.default.div`
  position: relative;
  width: 100%;
  transition: 0.5s ease-in-out;
  overflow: hidden;

  ${props => props.$shouldShowQueryBuilder ? `display: block; max-height: 300px; visibility: visible; margin-block-start: 0px;` : `display: block; max-height: 0px; visibility: hidden; margin-block-start:-${_uiTheme.euiThemeVars.euiSizeS};`}

  .${_securitysolutionTGrid.IS_DRAGGING_CLASS_NAME} & {
    display: block;
    max-height: 300px;
    visibility: visible;
    margin-block-start: 0px;
  }
`;
const QueryTabHeaderComponent = ({
  filterManager,
  show,
  showCallOutUnauthorizedMsg,
  status,
  timelineId
}) => {
  const getTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const getIsDataProviderVisible = (0, _react.useMemo)(() => _store.timelineSelectors.dataProviderVisibilitySelector(), []);
  const timelineType = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTimeline;
    return ((_getTimeline = getTimeline(state, timelineId)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults).timelineType;
  });
  const isDataProviderVisible = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getIsDataProviderVis;
    return (_getIsDataProviderVis = getIsDataProviderVisible(state, timelineId)) !== null && _getIsDataProviderVis !== void 0 ? _getIsDataProviderVis : _defaults.timelineDefaults.isDataProviderVisible;
  });
  const shouldShowQueryBuilder = isDataProviderVisible || timelineType === _timeline.TimelineType.template;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_search_or_filter.StatefulSearchOrFilter, {
    filterManager: filterManager,
    timelineId: timelineId
  })), showCallOutUnauthorizedMsg && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "timelineCallOutUnauthorized",
    title: i18n.CALL_OUT_UNAUTHORIZED_MSG,
    color: "warning",
    iconType: "warning",
    size: "s"
  })), status === _timeline.TimelineStatus.immutable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "timelineImmutableCallOut",
    title: i18n.CALL_OUT_IMMUTABLE,
    color: "primary",
    iconType: "warning",
    size: "s"
  })), show ? /*#__PURE__*/_react.default.createElement(DataProvidersContainer, {
    className: "data-providers-container",
    $shouldShowQueryBuilder: shouldShowQueryBuilder
  }, /*#__PURE__*/_react.default.createElement(_data_providers.DataProviders, {
    timelineId: timelineId
  })) : null);
};
const QueryTabHeader = exports.QueryTabHeader = /*#__PURE__*/_react.default.memo(QueryTabHeaderComponent);