"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHistogramCustomization = void 0;
var _public = require("@kbn/unified-search-plugin/public");
var _react = require("react");
var _constants = require("../../../../../../actions/constants");
var _kibana = require("../../../../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isClickTriggerEvent = e => {
  return Array.isArray(e.data) && 'column' in e.data[0];
};
const isMultiValueTriggerEvent = e => {
  return Array.isArray(e.data) && 'cells' in e.data[0];
};
const useHistogramCustomization = () => {
  const {
    services: {
      customDataService: discoverDataService,
      uiActions
    }
  } = (0, _kibana.useKibana)();
  const onFilterCallback = (0, _react.useCallback)(async eventData => {
    if (eventData.preventDefault) eventData.preventDefault();
    let filters;
    if (isClickTriggerEvent(eventData)) {
      var _eventData$negate;
      filters = await discoverDataService.actions.createFiltersFromValueClickAction({
        data: eventData.data,
        negate: (_eventData$negate = eventData.negate) !== null && _eventData$negate !== void 0 ? _eventData$negate : false
      });
    } else if (isMultiValueTriggerEvent(eventData)) {
      filters = await discoverDataService.actions.createFiltersFromMultiValueClickAction({
        data: eventData.data,
        negate: eventData.negate
      });
    } else {
      // no-op
      return;
    }
    if (filters && !Array.isArray(filters)) {
      filters = [filters];
    }
    if (filters && filters.length > 0) {
      const applyFilterTrigger = uiActions.getTrigger(_constants.EsqlInTimelineTrigger.HISTOGRAM_TRIGGER);
      await applyFilterTrigger.exec({
        filters,
        timeFieldName: eventData.timeFieldName
      });
    }
  }, [uiActions, discoverDataService.actions]);
  const onBrushEndCallback = (0, _react.useCallback)(data => {
    discoverDataService.query.timefilter.timefilter.setTime({
      from: new Date(data.range[0]).toISOString(),
      to: new Date(data.range[1]).toISOString(),
      mode: 'absolute'
    });
    if (data.preventDefault) data.preventDefault();
  }, [discoverDataService.query.timefilter.timefilter]);
  const setHistogramCustomizationCallback = (0, _react.useCallback)(({
    customizations
  }) => {
    customizations.set({
      id: 'unified_histogram',
      onFilter: onFilterCallback,
      onBrushEnd: onBrushEndCallback,
      withDefaultActions: false,
      disabledActions: [_public.ACTION_GLOBAL_APPLY_FILTER]
    });
  }, [onFilterCallback, onBrushEndCallback]);
  return setHistogramCustomizationCallback;
};
exports.useHistogramCustomization = useHistogramCustomization;