"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineContainer = exports.TimelineBodyGlobalStyle = exports.TimelineBody = exports.SELECTOR_TIMELINE_GLOBAL_CONTAINER = exports.SELECTOR_TIMELINE_BODY_CLASS_NAME = exports.HideShowContainer = exports.EventsTrSupplementContainer = exports.EventsTrSupplement = exports.EventsTrHeader = exports.EventsTrGroup = exports.EventsTrData = exports.EventsThead = exports.EventsThGroupData = exports.EventsThGroupActions = exports.EventsThContent = exports.EventsTh = exports.EventsTdGroupData = exports.EventsTdGroupActions = exports.EventsTdContent = exports.EventsTd = exports.EventsTbody = exports.EventsTable = exports.EventsLoading = exports.EventsHeadingTitleSpan = exports.EventsHeadingTitleButton = exports.EventsHeadingHandle = exports.EventsHeadingExtra = exports.EventsHeading = exports.EVENTS_TD_CLASS_NAME = exports.EVENTS_TABLE_CLASS_NAME = void 0;
var _eui = require("@elastic/eui");
var _polished = require("polished");
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _securitysolutionTGrid = require("@kbn/securitysolution-t-grid");
var _helpers = require("./helpers");
var _translations = require("./translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * TIMELINE BODY
 */
const SELECTOR_TIMELINE_GLOBAL_CONTAINER = exports.SELECTOR_TIMELINE_GLOBAL_CONTAINER = 'securitySolutionTimeline__container';
const TimelineContainer = exports.TimelineContainer = _styledComponents.default.div.attrs(({
  className = ''
}) => ({
  className: `${SELECTOR_TIMELINE_GLOBAL_CONTAINER} ${className}`
}))`
  height: 100%;
  display: flex;
  flex-direction: column;
  position: relative;
`;

/**
 * TIMELINE BODY
 */
const SELECTOR_TIMELINE_BODY_CLASS_NAME = exports.SELECTOR_TIMELINE_BODY_CLASS_NAME = 'securitySolutionTimeline__body';

// SIDE EFFECT: the following creates a global class selector
const TimelineBodyGlobalStyle = exports.TimelineBodyGlobalStyle = (0, _styledComponents.createGlobalStyle)`
  body.${_securitysolutionTGrid.IS_TIMELINE_FIELD_DRAGGING_CLASS_NAME} .${SELECTOR_TIMELINE_BODY_CLASS_NAME} {
    overflow: hidden;
  }
`;
const TimelineBody = exports.TimelineBody = _styledComponents.default.div.attrs(({
  className = ''
}) => ({
  className: `${SELECTOR_TIMELINE_BODY_CLASS_NAME} ${className}`
}))`
  height: auto;
  overflow: auto;
  scrollbar-width: thin;
  flex: 1;
  display: block;

  &::-webkit-scrollbar {
    height: ${({
  theme
}) => theme.eui.euiScrollBar};
    width: ${({
  theme
}) => theme.eui.euiScrollBar};
  }

  &::-webkit-scrollbar-thumb {
    background-clip: content-box;
    background-color: ${({
  theme
}) => (0, _polished.rgba)(theme.eui.euiColorDarkShade, 0.5)};
    border: ${({
  theme
}) => theme.eui.euiScrollBarCorner} solid transparent;
  }

  &::-webkit-scrollbar-corner,
  &::-webkit-scrollbar-track {
    background-color: transparent;
  }
`;
TimelineBody.displayName = 'TimelineBody';

/**
 * EVENTS TABLE
 */

const EVENTS_TABLE_CLASS_NAME = exports.EVENTS_TABLE_CLASS_NAME = 'siemEventsTable';
const EventsTable = exports.EventsTable = _styledComponents.default.div.attrs(({
  className = '',
  $columnCount,
  columnWidths,
  $activePage,
  $rowCount,
  $totalPages
}) => ({
  'aria-label': (0, _translations.EVENTS_TABLE_ARIA_LABEL)({
    activePage: $activePage + 1,
    totalPages: $totalPages
  }),
  'aria-colcount': `${$columnCount}`,
  'aria-rowcount': `${$rowCount + 1}`,
  className: `siemEventsTable ${className}`,
  role: 'grid',
  style: {
    minWidth: `${columnWidths}px`
  },
  tabindex: '-1'
}))`
  padding: 3px;
`;

/* EVENTS HEAD */

const EventsThead = exports.EventsThead = _styledComponents.default.div.attrs(({
  className = ''
}) => ({
  className: `siemEventsTable__thead ${className}`,
  role: 'rowgroup'
}))`
  background-color: ${({
  theme
}) => theme.eui.euiColorEmptyShade};
  border-bottom: ${({
  theme
}) => theme.eui.euiBorderWidthThick} solid
    ${({
  theme
}) => theme.eui.euiColorLightShade};
  position: sticky;
  top: 0;
  z-index: ${({
  theme
}) => theme.eui.euiZLevel1};
`;
const EventsTrHeader = exports.EventsTrHeader = _styledComponents.default.div.attrs(({
  className
}) => ({
  'aria-rowindex': '1',
  className: `siemEventsTable__trHeader ${className}`,
  role: 'row'
}))`
  display: flex;
`;
const EventsThGroupActions = exports.EventsThGroupActions = _styledComponents.default.div.attrs(({
  className = ''
}) => ({
  'aria-colindex': `${_helpers.ACTIONS_COLUMN_ARIA_COL_INDEX}`,
  className: `siemEventsTable__thGroupActions ${className}`,
  role: 'columnheader',
  tabIndex: '0'
}))`
  display: flex;
  flex: 0 0
    ${({
  actionsColumnWidth,
  isEventViewer
}) => `${!isEventViewer ? actionsColumnWidth + 4 : actionsColumnWidth}px`};
  min-width: 0;
  padding-left: ${({
  isEventViewer
}) => !isEventViewer ? '4px;' : '0;'}; // match timeline event border
`;
const EventsThGroupData = exports.EventsThGroupData = _styledComponents.default.div.attrs(({
  className = ''
}) => ({
  className: `siemEventsTable__thGroupData ${className}`
}))`
  display: flex;

  > div:hover .siemEventsHeading__handle {
    display: ${({
  isDragging
}) => isDragging ? 'none' : 'block'};
    opacity: 1;
    visibility: visible;
  }
`;
const EventsTh = exports.EventsTh = _styledComponents.default.div.attrs(({
  className = '',
  role = 'columnheader'
}) => ({
  className: `siemEventsTable__th ${className}`,
  role
}))`
  align-items: center;
  display: flex;
  flex-shrink: 0;
  min-width: 0;

  .siemEventsTable__thGroupActions &:first-child:last-child {
    flex: 1;
  }

  .siemEventsTable__thGroupData &:hover {
    background-color: ${({
  theme
}) => theme.eui.euiTableHoverColor};
    cursor: move; /* Fallback for IE11 */
    cursor: grab;
  }

  > div:focus {
    outline: 0; /* disable focus on Resizable element */
  }

  /* don't display Draggable placeholder */
  [data-rbd-placeholder-context-id] {
    display: none !important;
  }
`;
const EventsThContent = exports.EventsThContent = _styledComponents.default.div.attrs(({
  className = ''
}) => ({
  className: `siemEventsTable__thContent ${className}`
}))`
  font-size: ${({
  theme
}) => theme.eui.euiFontSizeXS};
  font-weight: ${({
  theme
}) => theme.eui.euiFontWeightSemiBold};
  line-height: ${({
  theme
}) => theme.eui.euiLineHeight};
  min-width: 0;
  padding: ${({
  theme
}) => theme.eui.euiSizeXS};
  text-align: ${({
  textAlign
}) => textAlign};
  width: ${({
  width
}) => width != null ? `${width}px` : '100%'}; /* Using width: 100% instead of flex: 1 and max-width: 100% for IE11 */

  > button.euiButtonIcon,
  > .euiToolTipAnchor > button.euiButtonIcon {
    margin-left: ${({
  theme
}) => `-${theme.eui.euiSizeXS}`};
  }
`;

/* EVENTS BODY */

const EventsTbody = exports.EventsTbody = _styledComponents.default.div.attrs(({
  className = ''
}) => ({
  className: `siemEventsTable__tbody ${className}`,
  role: 'rowgroup'
}))`
  overflow-x: hidden;
`;
const EventsTrGroup = exports.EventsTrGroup = _styledComponents.default.div.attrs(({
  className = '',
  $ariaRowindex
}) => ({
  'aria-rowindex': `${$ariaRowindex}`,
  className: `siemEventsTable__trGroup ${className}`,
  role: 'row'
}))`
  border-bottom: ${({
  theme
}) => theme.eui.euiBorderWidthThin} solid
    ${({
  theme
}) => theme.eui.euiColorLightShade};
  ${({
  theme,
  eventType,
  isEvenEqlSequence,
  showLeftBorder
}) => showLeftBorder ? `border-left: 4px solid
    ${eventType === 'raw' ? theme.eui.euiColorLightShade : eventType === 'eql' && isEvenEqlSequence ? theme.eui.euiColorPrimary : eventType === 'eql' && !isEvenEqlSequence ? theme.eui.euiColorAccent : theme.eui.euiColorWarning}` : ''};
  ${({
  isBuildingBlockType
}) => isBuildingBlockType ? 'background: repeating-linear-gradient(127deg, rgba(245, 167, 0, 0.2), rgba(245, 167, 0, 0.2) 1px, rgba(245, 167, 0, 0.05) 2px, rgba(245, 167, 0, 0.05) 10px);' : ''};
  ${({
  eventType,
  isEvenEqlSequence
}) => eventType === 'eql' ? isEvenEqlSequence ? 'background: repeating-linear-gradient(127deg, rgba(0, 107, 180, 0.2), rgba(0, 107, 180, 0.2) 1px, rgba(0, 107, 180, 0.05) 2px, rgba(0, 107, 180, 0.05) 10px);' : 'background: repeating-linear-gradient(127deg, rgba(221, 10, 115, 0.2), rgba(221, 10, 115, 0.2) 1px, rgba(221, 10, 115, 0.05) 2px, rgba(221, 10, 115, 0.05) 10px);' : ''};

  &:hover {
    background-color: ${({
  theme
}) => theme.eui.euiTableHoverColor};
  }

  ${({
  isExpanded,
  theme
}) => isExpanded && `
    background: ${theme.eui.euiTableSelectedColor};

    &:hover {
      ${theme.eui.euiTableHoverSelectedColor}
    }
  `}
`;
const EventsTrData = exports.EventsTrData = _styledComponents.default.div.attrs(({
  className = ''
}) => ({
  className: `siemEventsTable__trData ${className}`
}))`
  display: flex;
`;
const TIMELINE_EVENT_DETAILS_OFFSET = 40;
const EventsTrSupplementContainer = exports.EventsTrSupplementContainer = _styledComponents.default.div.attrs(({
  width
}) => ({
  role: 'dialog',
  style: {
    width: `${width - TIMELINE_EVENT_DETAILS_OFFSET}px`
  }
}))``;
const EventsTrSupplement = exports.EventsTrSupplement = _styledComponents.default.div.attrs(({
  className = ''
}) => ({
  className: `siemEventsTable__trSupplement ${className}`
}))`
  display: ${({
  $display
}) => $display !== null && $display !== void 0 ? $display : 'inline-block'};
  font-size: ${({
  theme
}) => theme.eui.euiFontSizeXS};
  line-height: ${({
  theme
}) => theme.eui.euiLineHeight};
  padding-left: ${({
  theme
}) => theme.eui.euiSizeM};
  .euiAccordion + div {
    background-color: ${({
  theme
}) => theme.eui.euiColorEmptyShade};
    padding: 0 ${({
  theme
}) => theme.eui.euiSizeS};
    border: 1px solid ${({
  theme
}) => theme.eui.euiColorLightShade};
    border-radius: ${({
  theme
}) => theme.eui.euiSizeXS};
  }
`;
const EventsTdGroupActions = exports.EventsTdGroupActions = _styledComponents.default.div.attrs(({
  className = ''
}) => ({
  'aria-colindex': `${_helpers.ACTIONS_COLUMN_ARIA_COL_INDEX}`,
  className: `siemEventsTable__tdGroupActions ${className}`,
  role: 'gridcell'
}))`
  align-items: center;
  display: flex;
  flex: 0 0 ${({
  width
}) => `${width}px`};
  min-width: 0;
`;
const EventsTdGroupData = exports.EventsTdGroupData = _styledComponents.default.div.attrs(({
  className = ''
}) => ({
  className: `siemEventsTable__tdGroupData ${className}`
}))`
  display: flex;
`;
const EVENTS_TD_CLASS_NAME = exports.EVENTS_TD_CLASS_NAME = 'siemEventsTable__td';
const EventsTd = exports.EventsTd = _styledComponents.default.div.attrs(({
  className = '',
  $ariaColumnIndex,
  width
}) => {
  const common = {
    className: `siemEventsTable__td ${className}`,
    role: 'gridcell',
    style: {
      flexBasis: width ? `${width}px` : 'auto'
    }
  };
  return $ariaColumnIndex != null ? {
    ...common,
    'aria-colindex': `${$ariaColumnIndex}`
  } : common;
})`
  align-items: center;
  display: flex;
  flex-shrink: 0;
  min-width: 0;

  .siemEventsTable__tdGroupActions &:first-child:last-child {
    flex: 1;
  }
`;
const EventsTdContent = exports.EventsTdContent = _styledComponents.default.div.attrs(({
  className
}) => ({
  className: `siemEventsTable__tdContent ${className != null ? className : ''}`
}))`
  font-size: ${({
  theme
}) => theme.eui.euiFontSizeXS};
  line-height: ${({
  theme
}) => theme.eui.euiLineHeight};
  min-width: 0;
  padding: ${({
  theme
}) => theme.eui.euiSizeXS};
  text-align: ${({
  textAlign
}) => textAlign};
  width: ${({
  width
}) => width != null ? `${width}px` : '100%'}; /* Using width: 100% instead of flex: 1 and max-width: 100% for IE11 */

  button.euiButtonIcon {
    margin-left: ${({
  theme
}) => `-${theme.eui.euiSizeXS}`};
  }
`;

/**
 * EVENTS HEADING
 */

const EventsHeading = exports.EventsHeading = _styledComponents.default.div.attrs(({
  className = ''
}) => ({
  className: `siemEventsHeading ${className}`
}))`
  align-items: center;
  display: flex;

  &:hover {
    cursor: ${({
  isLoading
}) => isLoading ? 'wait' : 'grab'};
  }
`;
const EventsHeadingTitleButton = exports.EventsHeadingTitleButton = _styledComponents.default.button.attrs(({
  className = ''
}) => ({
  className: `siemEventsHeading__title siemEventsHeading__title--aggregatable ${className}`,
  type: 'button'
}))`
  align-items: center;
  display: flex;
  font-weight: inherit;
  min-width: 0;

  &:hover,
  &:focus {
    color: ${({
  theme
}) => theme.eui.euiColorPrimary};
    text-decoration: underline;
  }

  &:hover {
    cursor: pointer;
  }

  & > * + * {
    margin-left: ${({
  theme
}) => theme.eui.euiSizeXS};
  }
`;
const EventsHeadingTitleSpan = exports.EventsHeadingTitleSpan = _styledComponents.default.span.attrs(({
  className
}) => ({
  className: `siemEventsHeading__title siemEventsHeading__title--notAggregatable ${className}`
}))`
  min-width: 0;
`;
const EventsHeadingExtra = exports.EventsHeadingExtra = _styledComponents.default.div.attrs(({
  className = ''
}) => ({
  className: `siemEventsHeading__extra ${className}`
}))`
  margin-left: auto;
  margin-right: 2px;

  &.siemEventsHeading__extra--close {
    opacity: 0;
    transition: all ${({
  theme
}) => theme.eui.euiAnimSpeedNormal} ease;
    visibility: hidden;

    .siemEventsTable__th:hover & {
      opacity: 1;
      visibility: visible;
    }
  }
`;
const EventsHeadingHandle = exports.EventsHeadingHandle = _styledComponents.default.div.attrs(({
  className = ''
}) => ({
  className: `siemEventsHeading__handle ${className}`
}))`
  background-color: ${({
  theme
}) => theme.eui.euiBorderColor};
  height: 100%;
  opacity: 0;
  transition: all ${({
  theme
}) => theme.eui.euiAnimSpeedNormal} ease;
  visibility: hidden;
  width: ${({
  theme
}) => theme.eui.euiBorderWidthThick};

  &:hover {
    background-color: ${({
  theme
}) => theme.eui.euiColorPrimary};
    cursor: col-resize;
  }
`;

/**
 * EVENTS LOADING
 */

const EventsLoading = exports.EventsLoading = (0, _styledComponents.default)(_eui.EuiLoadingSpinner)`
  margin: 0 2px;
  vertical-align: middle;
`;
const HideShowContainer = exports.HideShowContainer = _styledComponents.default.div.attrs(({
  $isVisible = false
}) => ({
  style: {
    display: $isVisible ? 'block' : 'none'
  }
}))``;