"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EqlQueryBarTimeline = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _sourcerer = require("../../../../../common/containers/sourcerer");
var _use_selector = require("../../../../../common/hooks/use_selector");
var _model = require("../../../../../common/store/sourcerer/model");
var _eql_query_bar = require("../../../../../detection_engine/rule_creation_ui/components/eql_query_bar");
var _validators = require("../../../../../detection_engine/rule_creation_ui/components/eql_query_bar/validators");
var _shared_imports = require("../../../../../shared_imports");
var _store = require("../../../../store");
var i18n = _interopRequireWildcard(require("../translations"));
var _selectors = require("./selectors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultValues = {
  index: [],
  eqlQueryBar: {
    query: {
      query: '',
      language: 'eql'
    },
    filters: [],
    saved_id: null
  },
  eqlOptions: {}
};
const schema = {
  index: {
    fieldsToValidateOnChange: ['index', 'eqlQueryBar'],
    validations: []
  },
  eqlOptions: {
    fieldsToValidateOnChange: ['eqlOptions', 'eqlQueryBar']
  },
  eqlQueryBar: {
    validations: [{
      validator: (0, _validators.debounceAsync)(_validators.eqlValidator, 300)
    }]
  }
};
const HiddenUseField = (0, _styledComponents.default)(_shared_imports.UseField)`
  display: none;
`;

// eslint-disable-next-line react/display-name
const EqlQueryBarTimeline = exports.EqlQueryBarTimeline = /*#__PURE__*/(0, _react.memo)(({
  timelineId
}) => {
  var _optionsSelected$quer;
  const dispatch = (0, _reactRedux.useDispatch)();
  const isInit = (0, _react.useRef)(true);
  const [isQueryBarValid, setIsQueryBarValid] = (0, _react.useState)(false);
  const [isQueryBarValidating, setIsQueryBarValidating] = (0, _react.useState)(false);
  const getOptionsSelected = (0, _react.useMemo)(() => (0, _selectors.getEqlOptions)(), []);
  const optionsSelected = (0, _use_selector.useDeepEqualSelector)(state => getOptionsSelected(state, timelineId));
  const {
    loading: indexPatternsLoading,
    indexPattern,
    selectedPatterns
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const initialState = {
    ...defaultValues,
    index: selectedPatterns.sort(),
    eqlQueryBar: {
      ...defaultValues.eqlQueryBar,
      query: {
        query: (_optionsSelected$quer = optionsSelected.query) !== null && _optionsSelected$quer !== void 0 ? _optionsSelected$quer : '',
        language: 'eql'
      }
    }
  };
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: initialState,
    options: {
      stripEmptyFields: false
    },
    schema
  });
  const {
    getFields,
    setFieldValue
  } = form;
  const onOptionsChange = (0, _react.useCallback)((field, value) => {
    dispatch(_store.timelineActions.updateEqlOptions({
      id: timelineId,
      field,
      value
    }));
    setFieldValue('eqlOptions', {
      ...optionsSelected,
      [field]: value
    });
  }, [dispatch, optionsSelected, setFieldValue, timelineId]);
  const [{
    eqlQueryBar: formEqlQueryBar
  }] = (0, _shared_imports.useFormData)({
    form,
    watch: ['eqlQueryBar']
  });
  const prevEqlQuery = (0, _react.useRef)('');
  const optionsData = (0, _react.useMemo)(() => (0, _lodash.isEmpty)(indexPattern.fields) ? {
    keywordFields: [],
    dateFields: [],
    nonDateFields: []
  } : {
    keywordFields: indexPattern.fields.filter(f => {
      var _f$esTypes;
      return (_f$esTypes = f.esTypes) === null || _f$esTypes === void 0 ? void 0 : _f$esTypes.includes('keyword');
    }).map(f => ({
      label: f.name
    })),
    dateFields: indexPattern.fields.filter(f => f.type === 'date').map(f => ({
      label: f.name
    })),
    nonDateFields: indexPattern.fields.filter(f => f.type !== 'date').map(f => ({
      label: f.name
    }))
  }, [indexPattern]);
  (0, _react.useEffect)(() => {
    const {
      index: indexField
    } = getFields();
    const newIndexValue = selectedPatterns.sort();
    const indexFieldValue = indexField.value.sort();
    if (!(0, _lodash.isEqual)(indexFieldValue, newIndexValue)) {
      indexField.setValue(newIndexValue);
    }
  }, [getFields, selectedPatterns]);
  (0, _react.useEffect)(() => {
    const {
      eqlQueryBar
    } = getFields();
    if (isInit.current) {
      var _optionsSelected$quer2;
      isInit.current = false;
      setIsQueryBarValidating(true);
      eqlQueryBar.setValue({
        ...defaultValues.eqlQueryBar,
        query: {
          query: (_optionsSelected$quer2 = optionsSelected.query) !== null && _optionsSelected$quer2 !== void 0 ? _optionsSelected$quer2 : '',
          language: 'eql'
        }
      });
    }
    return () => {
      isInit.current = true;
    };
  }, [getFields, optionsSelected.query]);
  (0, _react.useEffect)(() => {
    if (formEqlQueryBar != null && prevEqlQuery.current !== formEqlQueryBar.query.query && isQueryBarValid && !isQueryBarValidating) {
      prevEqlQuery.current = formEqlQueryBar.query.query;
      dispatch(_store.timelineActions.updateEqlOptions({
        id: timelineId,
        field: 'query',
        value: `${formEqlQueryBar.query.query}`
      }));
      setIsQueryBarValid(false);
      setIsQueryBarValidating(false);
    }
  }, [dispatch, formEqlQueryBar, isQueryBarValid, isQueryBarValidating, timelineId]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    "data-test-subj": "EqlQueryBarTimeline"
  }, /*#__PURE__*/_react.default.createElement(HiddenUseField, {
    key: "Index",
    path: "index"
  }), /*#__PURE__*/_react.default.createElement(HiddenUseField, {
    key: "EqlOptions",
    path: "eqlOptions"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    key: "EqlQueryBar",
    path: "eqlQueryBar",
    component: _eql_query_bar.EqlQueryBar,
    componentProps: {
      optionsData,
      optionsSelected,
      onOptionsChange,
      onValidityChange: setIsQueryBarValid,
      onValiditingChange: setIsQueryBarValidating,
      idAria: 'timelineEqlQueryBar',
      isDisabled: indexPatternsLoading,
      isLoading: indexPatternsLoading,
      indexPattern,
      dataTestSubj: 'timelineEqlQueryBar'
    },
    config: {
      ...schema.eqlQueryBar,
      label: i18n.EQL_QUERY_BAR_LABEL
    }
  }));
});