"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotesButton = exports.NOTES_BUTTON_CLASS_NAME = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _timeline = require("../../../../../common/api/timeline");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NotesCountBadge = (0, _styledComponents.default)(_eui.EuiBadge)`
  margin-left: 5px;
`;
NotesCountBadge.displayName = 'NotesCountBadge';
const NOTES_BUTTON_CLASS_NAME = exports.NOTES_BUTTON_CLASS_NAME = 'notes-button';
const SmallNotesButton = /*#__PURE__*/_react.default.memo(({
  ariaLabel = i18n.NOTES,
  isDisabled,
  toggleShowNotes,
  timelineType
}) => {
  const isTemplate = timelineType === _timeline.TimelineType.template;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": ariaLabel,
    className: NOTES_BUTTON_CLASS_NAME,
    "data-test-subj": "timeline-notes-button-small",
    disabled: isDisabled,
    iconType: "editorComment",
    onClick: toggleShowNotes,
    size: "s",
    isDisabled: isTemplate
  });
});
SmallNotesButton.displayName = 'SmallNotesButton';
const NotesButton = exports.NotesButton = /*#__PURE__*/_react.default.memo(({
  ariaLabel,
  isDisabled,
  showNotes,
  timelineType,
  toggleShowNotes,
  toolTip
}) => showNotes ? /*#__PURE__*/_react.default.createElement(SmallNotesButton, {
  ariaLabel: ariaLabel,
  isDisabled: isDisabled,
  toggleShowNotes: toggleShowNotes,
  timelineType: timelineType
}) : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: toolTip || '',
  "data-test-subj": "timeline-notes-tool-tip"
}, /*#__PURE__*/_react.default.createElement(SmallNotesButton, {
  ariaLabel: ariaLabel,
  isDisabled: isDisabled,
  toggleShowNotes: toggleShowNotes,
  timelineType: timelineType
})));
NotesButton.displayName = 'NotesButton';