"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPinIcon = exports.getDefaultAriaLabel = exports.Pin = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _timeline = require("../../../../../common/api/timeline");
var i18n = _interopRequireWildcard(require("../body/translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPinIcon = pinned => pinned ? 'pinFilled' : 'pin';
exports.getPinIcon = getPinIcon;
const getDefaultAriaLabel = ({
  isAlert,
  isTemplate,
  isPinned
}) => {
  if (isTemplate) {
    return i18n.DISABLE_PIN(isAlert);
  } else if (isPinned) {
    return i18n.PINNED(isAlert);
  } else {
    return i18n.UNPINNED(isAlert);
  }
};
exports.getDefaultAriaLabel = getDefaultAriaLabel;
const Pin = exports.Pin = /*#__PURE__*/_react.default.memo(({
  ariaLabel,
  allowUnpinning,
  isAlert,
  isDisabled,
  onClick = _fp.noop,
  pinned,
  timelineType
}) => {
  const isTemplate = timelineType === _timeline.TimelineType.template;
  const defaultAriaLabel = getDefaultAriaLabel({
    isAlert,
    isTemplate,
    isPinned: pinned
  });
  const pinAriaLabel = ariaLabel != null && !isTemplate ? ariaLabel : defaultAriaLabel;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": pinAriaLabel,
    "data-test-subj": "pin",
    iconType: getPinIcon(pinned),
    onClick: onClick,
    isDisabled: isDisabled || isTemplate || !allowUnpinning,
    size: "s"
  });
});
Pin.displayName = 'Pin';