"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineKpisContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _reactRedux = require("react-redux");
var _common = require("@kbn/data-plugin/common");
var _eui = require("@elastic/eui");
var _types = require("../../../../../common/types");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _use_selector = require("../../../../common/hooks/use_selector");
var _model = require("../../../../common/store/sourcerer/model");
var _kpis = require("./kpis");
var _kpis2 = require("../../../containers/kpis");
var _kibana = require("../../../../common/lib/kibana");
var _store = require("../../../store");
var _defaults = require("../../../store/defaults");
var _kuery = require("../../../../common/lib/kuery");
var _selectors = require("../../../../common/components/super_date_picker/selectors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TimelineKpisContainer = ({
  timelineId
}) => {
  var _combinedQueries$filt;
  const {
    browserFields,
    indexPattern,
    selectedPatterns
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const esQueryConfig = (0, _react.useMemo)(() => (0, _common.getEsQueryConfig)(uiSettings), [uiSettings]);
  const getTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const {
    dataProviders,
    filters,
    kqlMode
  } = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTimeline;
    return (0, _fp.pick)(['dataProviders', 'filters', 'kqlMode'], (_getTimeline = getTimeline(state, timelineId)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults);
  });
  const getKqlQueryTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getKqlFilterQuerySelector(), []);
  const kqlQueryTimeline = (0, _reactRedux.useSelector)(state => getKqlQueryTimeline(state, timelineId));
  const kqlQueryExpression = kqlQueryTimeline !== null && kqlQueryTimeline !== void 0 ? kqlQueryTimeline : ' ';
  const kqlQuery = (0, _react.useMemo)(() => ({
    query: kqlQueryExpression,
    language: 'kuery'
  }), [kqlQueryExpression]);
  const isActive = (0, _react.useMemo)(() => timelineId === _types.TimelineId.active, [timelineId]);
  const getStartSelector = (0, _react.useMemo)(() => (0, _selectors.startSelector)(), []);
  const getEndSelector = (0, _react.useMemo)(() => (0, _selectors.endSelector)(), []);
  const timerange = (0, _use_selector.useDeepEqualSelector)(state => {
    if (isActive) {
      return {
        from: getStartSelector(state.inputs.timeline),
        to: getEndSelector(state.inputs.timeline),
        interval: ''
      };
    } else {
      return {
        from: getStartSelector(state.inputs.global),
        to: getEndSelector(state.inputs.global),
        interval: ''
      };
    }
  });
  const combinedQueries = (0, _react.useMemo)(() => (0, _kuery.combineQueries)({
    config: esQueryConfig,
    dataProviders,
    indexPattern,
    browserFields,
    filters: filters ? filters : [],
    kqlQuery,
    kqlMode
  }), [browserFields, dataProviders, esQueryConfig, filters, indexPattern, kqlMode, kqlQuery]);
  const isBlankTimeline = (0, _react.useMemo)(() => (0, _fp.isEmpty)(dataProviders) && (0, _fp.isEmpty)(filters) && (0, _fp.isEmpty)(kqlQuery.query) || (combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery) === undefined, [dataProviders, filters, kqlQuery, combinedQueries]);
  const [, kpis] = (0, _kpis2.useTimelineKpis)({
    defaultIndex: selectedPatterns,
    timerange,
    isBlankTimeline,
    filterQuery: (_combinedQueries$filt = combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery) !== null && _combinedQueries$filt !== void 0 ? _combinedQueries$filt : ''
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_kpis.TimelineKPIs, {
    kpis: kpis
  }));
};
exports.TimelineKpisContainer = TimelineKpisContainer;