"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ZeekDetails = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _netflow = require("../netflow");
var _zeek_signature = require("./zeek_signature");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Details = _styledComponents.default.div`
  margin: 5px 0;
`;
Details.displayName = 'Details';
const ZeekDetails = exports.ZeekDetails = /*#__PURE__*/_react.default.memo(({
  data,
  isDraggable,
  timelineId
}) => data.zeek != null ? /*#__PURE__*/_react.default.createElement(Details, null, /*#__PURE__*/_react.default.createElement(_zeek_signature.ZeekSignature, {
  data: data,
  isDraggable: isDraggable,
  timelineId: timelineId
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), /*#__PURE__*/_react.default.createElement(_netflow.NetflowRenderer, {
  data: data,
  isDraggable: isDraggable,
  timelineId: timelineId
})) : null);
ZeekDetails.displayName = 'ZeekDetails';