"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserName = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _fp = require("lodash/fp");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _user_right = require("../../../../../flyout/entity_details/user_right");
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
var _stateful_event_context = require("../../../../../common/components/events_viewer/stateful_event_context");
var _helpers = require("../../../../../helpers");
var _draggables = require("../../../../../common/components/draggables");
var _empty_value = require("../../../../../common/components/empty_value");
var _links = require("../../../../../common/components/links");
var _truncatable_text = require("../../../../../common/components/truncatable_text");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UserNameComponent = ({
  fieldName,
  Component,
  contextId,
  eventId,
  fieldType,
  isAggregatable,
  isDraggable,
  isButton,
  onClick,
  title,
  value
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const eventContext = (0, _react.useContext)(_stateful_event_context.StatefulEventContext);
  const isNewUserDetailsFlyoutEnable = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newUserDetailsFlyout');
  const expandableTimelineFlyoutEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('expandableTimelineFlyoutEnabled');
  const userName = `${value}`;
  const isInTimelineContext = userName && (eventContext === null || eventContext === void 0 ? void 0 : eventContext.timelineID);
  const {
    openRightPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const openUserDetailsSidePanel = (0, _react.useCallback)(e => {
    e.preventDefault();
    if (onClick) {
      onClick();
    }
    if (!eventContext || !isInTimelineContext) {
      return;
    }
    const {
      timelineID,
      tabType
    } = eventContext;
    const openNewFlyout = () => openRightPanel({
      id: _user_right.UserPanelKey,
      params: {
        userName,
        contextID: contextId,
        scopeId: timelineID,
        isDraggable
      }
    });
    const openOldFlyout = () => {
      const updatedExpandedDetail = {
        panelView: 'userDetail',
        params: {
          userName
        }
      };
      const scopedActions = (0, _helpers.getScopedActions)(timelineID);
      if (scopedActions) {
        dispatch(scopedActions.toggleDetailPanel({
          ...updatedExpandedDetail,
          id: timelineID,
          tabType: tabType
        }));
      }
    };
    if ((0, _helpers.isTimelineScope)(timelineID) && isNewUserDetailsFlyoutEnable && expandableTimelineFlyoutEnabled || isNewUserDetailsFlyoutEnable) {
      openNewFlyout();
    } else {
      openOldFlyout();
    }
  }, [contextId, dispatch, eventContext, expandableTimelineFlyoutEnabled, isDraggable, isInTimelineContext, isNewUserDetailsFlyoutEnable, onClick, openRightPanel, userName]);

  // The below is explicitly defined this way as the onClick takes precedence when it and the href are both defined
  // When this component is used outside of timeline/alerts table (i.e. in the flyout) we would still like it to link to the User Details page
  const content = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_links.UserDetailsLink, {
    Component: Component,
    userName: userName,
    isButton: isButton,
    onClick: isInTimelineContext ? openUserDetailsSidePanel : undefined,
    title: title
  }, /*#__PURE__*/_react.default.createElement(_truncatable_text.TruncatableText, {
    "data-test-subj": "draggable-truncatable-content"
  }, userName)), [userName, isButton, isInTimelineContext, openUserDetailsSidePanel, Component, title]);
  return (0, _fp.isString)(value) && userName.length > 0 ? isDraggable ? /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
    field: fieldName,
    id: `event-details-value-default-draggable-${contextId}-${eventId}-${fieldName}-${value}`,
    fieldType: fieldType,
    isAggregatable: isAggregatable,
    isDraggable: isDraggable,
    tooltipContent: fieldName,
    value: userName
  }, content) : content : (0, _empty_value.getEmptyTagValue)();
};
const UserName = exports.UserName = /*#__PURE__*/_react.default.memo(UserNameComponent);
UserName.displayName = 'UserName';