"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLinksFromSignature = exports.getBeginningTokens = void 0;
var _fp = require("lodash/fp");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const lazySuricataLibConfiguration = () => {
  /**
   * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
   * See https://webpack.js.org/api/module-methods/#magic-comments
   */
  return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazy_suricata_lib_configuration" */
  'suricata-sid-db')));
};
const has = (obj, key) => Object.prototype.hasOwnProperty.call(obj, key);
const getLinksFromSignature = async id => {
  const db = (await lazySuricataLibConfiguration()).db;
  const refs = has(db, id) ? db[id] : null;
  if (refs != null) {
    return (0, _fp.uniq)(refs);
  } else {
    return [];
  }
};
exports.getLinksFromSignature = getLinksFromSignature;
const specialTokenRules = ['IPv4', 'IPv6'];
const getBeginningTokens = signature => {
  const signatureSplit = signature.trim().split(' ');
  return signatureSplit.reduce((accum, curr, index) => {
    if (accum.length === index && curr === curr.toUpperCase() && curr !== '' || specialTokenRules.includes(curr)) {
      return [...accum, curr];
    }
    return accum;
  }, []);
};
exports.getBeginningTokens = getBeginningTokens;