"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuricataDetails = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _netflow = require("../netflow");
var _suricata_signature = require("./suricata_signature");
var _suricata_refs = require("./suricata_refs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Details = _styledComponents.default.div`
  margin: 5px 0;
`;
Details.displayName = 'Details';
const SuricataDetails = exports.SuricataDetails = /*#__PURE__*/_react.default.memo(({
  data,
  isDraggable,
  timelineId
}) => {
  const signature = (0, _fp.get)('suricata.eve.alert.signature[0]', data);
  const signatureId = (0, _fp.get)('suricata.eve.alert.signature_id[0]', data);
  if (signatureId != null && signature != null) {
    return /*#__PURE__*/_react.default.createElement(Details, null, /*#__PURE__*/_react.default.createElement(_suricata_signature.SuricataSignature, {
      contextId: `suricata-signature-${timelineId}-${data._id}`,
      id: data._id,
      isDraggable: isDraggable,
      signature: signature,
      signatureId: signatureId
    }), /*#__PURE__*/_react.default.createElement(_suricata_refs.SuricataRefs, {
      signatureId: signatureId
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_netflow.NetflowRenderer, {
      data: data,
      isDraggable: isDraggable,
      timelineId: timelineId
    }));
  } else {
    return null;
  }
});
SuricataDetails.displayName = 'SuricataDetails';