"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RegistryEventDetails = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _helpers = require("../helpers");
var _registry_event_details_line = require("./registry_event_details_line");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RegistryEventDetailsComponent = ({
  contextId,
  data,
  isDraggable,
  text
}) => {
  const hostName = (0, _fp.get)('host.name[0]', data);
  const id = data._id;
  const processName = (0, _fp.get)('process.name[0]', data);
  const processPid = (0, _fp.get)('process.pid[0]', data);
  const registryKey = (0, _fp.get)('registry.key[0]', data);
  const registryPath = (0, _fp.get)('registry.path[0]', data);
  const userDomain = (0, _fp.get)('user.domain[0]', data);
  const userName = (0, _fp.get)('user.name[0]', data);
  if ((0, _helpers.isNillEmptyOrNotFinite)(registryKey)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_helpers.Details, null, /*#__PURE__*/_react.default.createElement(_registry_event_details_line.RegistryEventDetailsLine, {
    contextId: contextId,
    hostName: hostName,
    id: id,
    isDraggable: isDraggable,
    processName: processName,
    processPid: processPid,
    registryKey: registryKey,
    registryPath: registryPath,
    text: text,
    userDomain: userDomain,
    userName: userName
  }));
};
RegistryEventDetailsComponent.displayName = 'RegistryEventDetailsComponent';
const RegistryEventDetails = exports.RegistryEventDetails = /*#__PURE__*/_react.default.memo(RegistryEventDetailsComponent);