"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.plainColumnRenderer = exports.dataExistsAtColumn = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _empty_value = require("../../../../../common/components/empty_value");
var _formatted_field = require("./formatted_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dataExistsAtColumn = (columnName, data) => data.findIndex(item => item.field === columnName) !== -1;
exports.dataExistsAtColumn = dataExistsAtColumn;
const plainColumnRenderer = exports.plainColumnRenderer = {
  isInstance: (columnName, data) => dataExistsAtColumn(columnName, data),
  renderColumn: ({
    asPlainText,
    columnName,
    eventId,
    field,
    isDraggable = true,
    scopeId,
    truncate,
    values,
    linkValues
  }) => {
    if (!Array.isArray(values) || values.length === 0) {
      return (0, _empty_value.getEmptyTagValue)();
    }
    // Draggable columns should render individual fields to give the user
    // fine-grained control over the individual values
    if (isDraggable) {
      return values.map((value, i) => {
        var _field$format, _field$aggregatable, _field$type;
        return /*#__PURE__*/_react.default.createElement(_formatted_field.FormattedFieldValue, {
          asPlainText: asPlainText,
          contextId: `plain-column-renderer-formatted-field-value-${scopeId}`,
          eventId: eventId,
          fieldFormat: (_field$format = field.format) !== null && _field$format !== void 0 ? _field$format : '',
          fieldName: columnName,
          isAggregatable: (_field$aggregatable = field.aggregatable) !== null && _field$aggregatable !== void 0 ? _field$aggregatable : false,
          fieldType: (_field$type = field.type) !== null && _field$type !== void 0 ? _field$type : '',
          isDraggable: isDraggable,
          key: `plain-column-renderer-formatted-field-value-${scopeId}-${columnName}-${eventId}-${field.id}-${value}-${i}`,
          linkValue: (0, _fp.head)(linkValues),
          truncate: truncate,
          value: value
        });
      });
    } else {
      var _field$format2, _field$aggregatable2, _field$type2;
      // In case the column isn't draggable, fields are joined
      // to give users a faster overview of all values.
      // (note: the filter-related hover actions still produce individual filters for each value)
      return /*#__PURE__*/_react.default.createElement(_formatted_field.FormattedFieldValue, {
        asPlainText: asPlainText,
        contextId: `plain-column-renderer-formatted-field-value-${scopeId}`,
        eventId: eventId,
        fieldFormat: (_field$format2 = field.format) !== null && _field$format2 !== void 0 ? _field$format2 : '',
        fieldName: columnName,
        isAggregatable: (_field$aggregatable2 = field.aggregatable) !== null && _field$aggregatable2 !== void 0 ? _field$aggregatable2 : false,
        fieldType: (_field$type2 = field.type) !== null && _field$type2 !== void 0 ? _field$type2 : '',
        isDraggable: isDraggable,
        key: `plain-column-renderer-formatted-field-value-${scopeId}-${columnName}-${eventId}-${field.id}`,
        linkValue: (0, _fp.head)(linkValues),
        truncate: truncate,
        value: joinValues(values)
      });
    }
  }
};
function joinValues(values) {
  if (Array.isArray(values)) {
    if (values.length > 0) {
      return values.join(', ');
    } else {
      return values[0];
    }
  }
  return values;
}