"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ParentProcessDraggable = void 0;
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../../common/components/draggables");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ParentProcessDraggable = exports.ParentProcessDraggable = /*#__PURE__*/_react.default.memo(({
  contextId,
  endgameParentProcessName,
  eventId,
  isDraggable,
  processParentName,
  processParentPid,
  processPpid,
  text
}) => {
  if ((0, _helpers.isNillEmptyOrNotFinite)(processParentName) && (0, _helpers.isNillEmptyOrNotFinite)(endgameParentProcessName)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !(0, _helpers.isNillEmptyOrNotFinite)(text) && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    "data-test-subj": "parent-process-draggable-text",
    grow: false,
    component: "span"
  }, text), !(0, _helpers.isNillEmptyOrNotFinite)(processParentName) && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    grow: false,
    component: "span"
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: eventId,
    field: "process.parent.name",
    isDraggable: isDraggable,
    value: processParentName,
    fieldType: "keyword",
    isAggregatable: true
  })), !(0, _helpers.isNillEmptyOrNotFinite)(endgameParentProcessName) && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    grow: false,
    component: "span"
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: eventId,
    field: "endgame.parent_process_name",
    isDraggable: isDraggable,
    value: endgameParentProcessName,
    fieldType: "keyword",
    isAggregatable: true
  })), !(0, _helpers.isNillEmptyOrNotFinite)(processParentPid) && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    grow: false,
    component: "span"
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: eventId,
    field: "process.parent.pid",
    isDraggable: isDraggable,
    queryValue: String(processParentPid),
    value: `(${String(processParentPid)})`,
    fieldType: "keyword",
    isAggregatable: true
  })), !(0, _helpers.isNillEmptyOrNotFinite)(processPpid) && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    grow: false,
    component: "span"
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: eventId,
    field: "process.ppid",
    isDraggable: isDraggable,
    queryValue: String(processPpid),
    value: `(${String(processPpid)})`,
    fieldType: "keyword",
    isAggregatable: true
  })));
});
ParentProcessDraggable.displayName = 'ParentProcessDraggable';