"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostName = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _fp = require("lodash/fp");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
var _host_right = require("../../../../../flyout/entity_details/host_right");
var _stateful_event_context = require("../../../../../common/components/events_viewer/stateful_event_context");
var _helpers = require("../../../../../helpers");
var _links = require("../../../../../common/components/links");
var _draggables = require("../../../../../common/components/draggables");
var _empty_value = require("../../../../../common/components/empty_value");
var _truncatable_text = require("../../../../../common/components/truncatable_text");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HostNameComponent = ({
  fieldName,
  fieldType,
  isAggregatable,
  Component,
  contextId,
  eventId,
  isDraggable,
  isButton,
  onClick,
  title,
  value
}) => {
  const isNewHostDetailsFlyoutEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newHostDetailsFlyout');
  const expandableTimelineFlyoutEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('expandableTimelineFlyoutEnabled');
  const {
    openRightPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const eventContext = (0, _react.useContext)(_stateful_event_context.StatefulEventContext);
  const hostName = `${value}`;
  const isInTimelineContext = hostName && (eventContext === null || eventContext === void 0 ? void 0 : eventContext.enableHostDetailsFlyout) && (eventContext === null || eventContext === void 0 ? void 0 : eventContext.timelineID);
  const openHostDetailsSidePanel = (0, _react.useCallback)(e => {
    e.preventDefault();
    if (onClick) {
      onClick();
    }
    if (!eventContext || !isInTimelineContext) {
      return;
    }
    const {
      timelineID,
      tabType
    } = eventContext;
    const openNewFlyout = () => openRightPanel({
      id: _host_right.HostPanelKey,
      params: {
        hostName,
        contextID: contextId,
        scopeId: timelineID,
        isDraggable
      }
    });
    const openOldFlyout = () => {
      const updatedExpandedDetail = {
        panelView: 'hostDetail',
        params: {
          hostName
        }
      };
      const scopedActions = (0, _helpers.getScopedActions)(timelineID);
      if (scopedActions) {
        dispatch(scopedActions.toggleDetailPanel({
          ...updatedExpandedDetail,
          id: timelineID,
          tabType: tabType
        }));
      }
    };
    if ((0, _helpers.isTimelineScope)(timelineID) && isNewHostDetailsFlyoutEnabled && expandableTimelineFlyoutEnabled || isNewHostDetailsFlyoutEnabled) {
      openNewFlyout();
    } else {
      openOldFlyout();
    }
  }, [contextId, dispatch, eventContext, expandableTimelineFlyoutEnabled, hostName, isDraggable, isInTimelineContext, isNewHostDetailsFlyoutEnabled, onClick, openRightPanel]);

  // The below is explicitly defined this way as the onClick takes precedence when it and the href are both defined
  // When this component is used outside of timeline/alerts table (i.e. in the flyout) we would still like it to link to the Host Details page
  const content = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_links.HostDetailsLink, {
    Component: Component,
    hostName: hostName,
    isButton: isButton,
    onClick: isInTimelineContext ? openHostDetailsSidePanel : undefined,
    title: title
  }, /*#__PURE__*/_react.default.createElement(_truncatable_text.TruncatableText, {
    "data-test-subj": "draggable-truncatable-content"
  }, hostName)), [Component, hostName, isButton, isInTimelineContext, openHostDetailsSidePanel, title]);
  return (0, _fp.isString)(value) && hostName.length > 0 ? isDraggable ? /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
    field: fieldName,
    fieldType: fieldType,
    isAggregatable: isAggregatable,
    id: `event-details-value-default-draggable-${contextId}-${eventId}-${fieldName}-${value}`,
    isDraggable: isDraggable,
    tooltipContent: fieldName,
    value: hostName
  }, content) : content : (0, _empty_value.getEmptyTagValue)();
};
const HostName = exports.HostName = /*#__PURE__*/_react.default.memo(HostNameComponent);
HostName.displayName = 'HostName';