"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileDraggable = void 0;
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../../common/components/draggables");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FileDraggable = exports.FileDraggable = /*#__PURE__*/_react.default.memo(({
  contextId,
  endgameFileName,
  endgameFilePath,
  eventId,
  fileExtOriginalPath,
  fileName,
  filePath,
  isDraggable
}) => {
  if ((0, _helpers.isNillEmptyOrNotFinite)(fileName) && (0, _helpers.isNillEmptyOrNotFinite)(endgameFileName) && (0, _helpers.isNillEmptyOrNotFinite)(filePath) && (0, _helpers.isNillEmptyOrNotFinite)(endgameFilePath)) {
    return null;
  }
  const filePathIsKnown = !(0, _helpers.isNillEmptyOrNotFinite)(filePath) || !(0, _helpers.isNillEmptyOrNotFinite)(endgameFilePath);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !(0, _helpers.isNillEmptyOrNotFinite)(fileName) ? /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    grow: false,
    component: "span"
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: eventId,
    field: "file.name",
    isDraggable: isDraggable,
    value: fileName,
    iconType: "document",
    isAggregatable: true,
    fieldType: "keyword"
  })) : !(0, _helpers.isNillEmptyOrNotFinite)(endgameFileName) ? /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    grow: false,
    component: "span"
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: eventId,
    field: "endgame.file_name",
    isDraggable: isDraggable,
    value: endgameFileName,
    iconType: "document",
    isAggregatable: true,
    fieldType: "keyword"
  })) : null, filePathIsKnown && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    "data-test-subj": "in",
    grow: false,
    component: "span"
  }, i18n.IN), !(0, _helpers.isNillEmptyOrNotFinite)(filePath) ? /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    grow: false,
    component: "span"
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: eventId,
    field: "file.path",
    isDraggable: isDraggable,
    value: filePath,
    iconType: "document",
    isAggregatable: true,
    fieldType: "keyword"
  })) : !(0, _helpers.isNillEmptyOrNotFinite)(endgameFilePath) ? /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    grow: false,
    component: "span"
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: eventId,
    field: "endgame.file_path",
    isDraggable: isDraggable,
    value: endgameFilePath,
    iconType: "document",
    isAggregatable: true,
    fieldType: "keyword"
  })) : null, !(0, _helpers.isNillEmptyOrNotFinite)(fileExtOriginalPath) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    grow: false,
    component: "span"
  }, i18n.FROM_ITS_ORIGINAL_PATH), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    grow: false,
    component: "span"
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: eventId,
    field: "file.Ext.original.path",
    isDraggable: isDraggable,
    value: fileExtOriginalPath,
    iconType: "document",
    isAggregatable: true,
    fieldType: "keyword"
  }))));
});
FileDraggable.displayName = 'FileDraggable';