"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.emptyColumnRenderer = exports.dataNotExistsAtColumn = void 0;
var _react = _interopRequireDefault(require("react"));
var _draggable_wrapper = require("../../../../../common/components/drag_and_drop/draggable_wrapper");
var _helpers = require("../../../../../common/components/drag_and_drop/helpers");
var _empty_value = require("../../../../../common/components/empty_value");
var _data_provider = require("../../data_providers/data_provider");
var _provider = require("../../data_providers/provider");
var _parse_query_value = require("./parse_query_value");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dataNotExistsAtColumn = (columnName, data) => data.findIndex(item => item.field === columnName) === -1;
exports.dataNotExistsAtColumn = dataNotExistsAtColumn;
const emptyColumnRenderer = exports.emptyColumnRenderer = {
  isInstance: (columnName, data) => dataNotExistsAtColumn(columnName, data),
  renderColumn: ({
    columnName,
    eventId,
    field,
    isDraggable = true,
    scopeId,
    truncate
  }) => isDraggable ? /*#__PURE__*/_react.default.createElement(_draggable_wrapper.DraggableWrapper, {
    dataProvider: {
      enabled: true,
      id: (0, _helpers.escapeDataProviderId)(`empty-column-renderer-draggable-wrapper-${scopeId}-${columnName}-${eventId}-${field.id}`),
      name: `${columnName}: ${(0, _parse_query_value.parseQueryValue)(null)}`,
      queryMatch: {
        field: field.id,
        value: (0, _parse_query_value.parseQueryValue)(null),
        displayValue: (0, _empty_value.getEmptyValue)(),
        operator: _data_provider.EXISTS_OPERATOR
      },
      excluded: true,
      kqlQuery: '',
      and: []
    },
    isDraggable: isDraggable,
    key: `empty-column-renderer-draggable-wrapper-${scopeId}-${columnName}-${eventId}-${field.id}`,
    render: (dataProvider, _, snapshot) => snapshot.isDragging ? /*#__PURE__*/_react.default.createElement(_draggable_wrapper.DragEffects, null, /*#__PURE__*/_react.default.createElement(_provider.Provider, {
      dataProvider: dataProvider
    })) : /*#__PURE__*/_react.default.createElement("span", null, (0, _empty_value.getEmptyValue)()),
    truncate: truncate,
    scopeId: scopeId
  }) : /*#__PURE__*/_react.default.createElement("span", null, (0, _empty_value.getEmptyValue)())
};